#!/bin/bash

# Complete AI Features Deployment

echo "🚀 Deploying Complete AI Features..."

# 1. Update database schema
echo "📊 Updating database..."
pnpm db:migrate

# 2. Deploy AI modules
echo "🤖 Deploying AI modules..."
pnpm build

# 3. Setup N8N workflows
echo "🔗 Setting up N8N automation..."
curl -X POST http://localhost:5678/api/v1/workflows \
  -H "Content-Type: application/json" \
  -d @n8n-workflows/ai-automation.yaml

# 4. Verify deployments
echo "✅ Verifying deployments..."
curl http://localhost:3001/health
curl http://localhost:3000

# 5. Test AI features
echo "🧪 Testing AI features..."
curl -X POST http://localhost:3001/ai/test \
  -H "Content-Type: application/json" \
  -d '{"feature": "generate_product_content"}'

echo "✅ All AI features deployed successfully!"
echo ""
echo "Next steps:"
echo "1. Configure OpenAI API key: export OPENAI_API_KEY=sk_..."
echo "2. Configure Remove.bg API: export REMOVE_BG_API_KEY=..."
echo "3. Setup N8N at http://localhost:5678"
echo "4. Create N8N automation workflows"
echo "5. Test all features in dashboard"
echo ""
echo "Dashboard: http://localhost:3000/dashboard/ai"
echo "API Docs: http://localhost:3001/api/docs"