```markdown
# SaaS Tenant Prototype — Prisma + Postgres Integration

This repo now includes Prisma + PostgreSQL persistence for tenants.

What I added
- Prisma schema for Tenant model
- Prisma client singleton for Next.js
- Updated API: pages/api/tenants.ts persists tenants to Postgres and prevents duplicate subdomains
- .env.example with DATABASE_URL placeholder
- Updated package.json scripts to run Prisma commands

Quick local setup (assuming you have Postgres running)
1. Install deps
   pnpm install
   # or
   npm install

2. Create a Postgres database and set DATABASE_URL in .env
   Example .env:
   DATABASE_URL="postgresql://postgres:password@localhost:5432/saas_prototype?schema=public"

3. Generate Prisma client & run migrations
   pnpm prisma generate
   pnpm prisma migrate dev --name init

4. Start dev server
   pnpm dev
   Visit http://localhost:3000

Notes
- The API now saves tenants with status `PROVISIONING`. Later we'll add a background worker to process DNS/SSL/DB provisioning and update status to `ACTIVE`.
- For production, set connection pooling (PgBouncer) and adjust Prisma connection limits for serverless environments.
```