import { Module } from '@nestjs/common';
import { ConfigModule } from '@nestjs/config';
import { JwtModule } from '@nestjs/jwt';
import { DatabaseModule } from './database/database.module';
import { QueueModule } from './queue/queue.module';
import { TenantModule } from './modules/tenant/tenant.module';
import { AuthModule } from './modules/auth/auth.module';
import { ProductModule } from './modules/product/product.module';
import { CartModule } from './modules/cart/cart.module';
import { OrderModule } from './modules/order/order.module';
import { PaymentModule } from './modules/payment/payment.module';
import { ShippingModule } from './modules/shipping/shipping.module';
import { BillingModule } from './modules/billing/billing.module';
import { AffiliateModule } from './modules/affiliate/affiliate.module';
import { WholesalerModule } from './modules/wholesaler/wholesaler.module';
import { SuperAdminModule } from './modules/super-admin/super-admin.module';
import { MarketingModule } from './modules/marketing/marketing.module';
import { AnalyticsModule } from './modules/analytics/analytics.module';
import { AiModule } from './modules/ai/ai.module';
import { EmailMarketingModule } from './modules/email-marketing/email-marketing.module';
import { HealthModule } from './modules/health/health.module';

@Module({
  imports: [
    ConfigModule.forRoot({
      isGlobal: true,
      envFilePath: '.env'
    }),
    DatabaseModule,
    QueueModule,
    JwtModule.register({
      global: true,
      secret: process.env.JWT_SECRET || 'dev-secret',
      signOptions: { expiresIn: '7d' }
    }),
    TenantModule,
    AuthModule,
    ProductModule,
    CartModule,
    OrderModule,
    PaymentModule,
    ShippingModule,
    BillingModule,
    AffiliateModule,
    WholesalerModule,
    SuperAdminModule,
    MarketingModule,
    AnalyticsModule,
    AiModule,
    EmailMarketingModule,
    HealthModule
  ]
})
export class AppModule {}