import { Injectable } from '@nestjs/common';
import { translations } from './translations';

@Injectable()
export class I18nService {
  translate(key: string, lang: string = 'en'): string {
    const keys = key.split('.');
    let value: any = translations[lang] || translations['en'];

    for (const k of keys) {
      value = value?.[k];
    }

    return value || key;
  }

  getLanguages(): string[] {
    return Object.keys(translations);
  }
}