import { NestFactory } from '@nestjs/core';
import { ValidationPipe, Logger } from '@nestjs/common';
import { SwaggerModule, DocumentBuilder } from '@nestjs/swagger';
import { AppModule } from './app.module';

const logger = new Logger('Main');

async function bootstrap() {
  const app = await NestFactory.create(AppModule);

  // Middleware
  app.use((req, res, next) => {
    // Extract tenant from subdomain/custom domain
    const host = req.hostname;
    req['tenantHost'] = host;
    next();
  });

  app.useGlobalPipes(new ValidationPipe({ whitelist: true }));

  // Swagger
  const config = new DocumentBuilder()
    .setTitle('SaaS API')
    .setDescription('Enterprise multi-tenant SaaS API')
    .setVersion('1.0')
    .addBearerAuth()
    .build();
  const document = SwaggerModule.createDocument(app, config);
  SwaggerModule.setup('api/docs', app, document);

  // CORS
  app.enableCors({
    origin: process.env.CORS_ORIGIN || '*',
    credentials: true
  });

  const port = process.env.PORT || 3001;
  await app.listen(port);
  logger.log(`API running on port ${port}`);
}

bootstrap();