import { Injectable } from '@nestjs/common';
import { PrismaService } from '../../database/prisma.service';

@Injectable()
export class ActivityService {
  constructor(private prisma: PrismaService) {}

  // ক্রিয়াকলাপ রেকর্ড করুন
  async logActivity(
    tenantId: string,
    type: string,
    message: string,
    metadata?: any
  ) {
    await this.prisma.activity.create({
      data: {
        tenantId,
        type, // 'order', 'product', 'sync', 'login', etc.
        message,
        metadata
      }
    });
  }

  // ফিড পান
  async getActivityFeed(tenantId: string, limit = 50) {
    return await this.prisma.activity.findMany({
      where: { tenantId },
      take: limit,
      orderBy: { createdAt: 'desc' }
    });
  }
}