import { Injectable } from '@nestjs/common';
import { PrismaService } from '../../database/prisma.service';

@Injectable()
export class AffiliateAPIService {
  constructor(private prisma: PrismaService) {}

  // এক্সটার্নাল পার্টনারের জন্য API এন্ডপয়েন্ট
  async getAffiliateMetrics(affiliateId: string, apiKey: string) {
    // API কী ভেরিফাই করুন
    const affiliate = await this.prisma.affiliateAccount.findUnique({
      where: { id: affiliateId }
    });

    if (!affiliate) throw new Error('Affiliate not found');

    return {
      affiliateId,
      totalEarnings: affiliate.totalEarnings,
      totalClicks: affiliate.totalClicks,
      totalConversions: affiliate.totalConversions,
      commissionRate: affiliate.commissionRate,
      lastUpdated: new Date()
    };
  }

  // Webhook: নতুন বিক্রয়ের জন্য
  async triggerSaleWebhook(affiliateId: string, saleData: any) {
    // এক্সটার্নাল সিস্টেমে webhook পাঠান
    // TODO: Implement webhook delivery
  }

  // API: কমিশন হিস্ট্রি পান
  async getCommissionHistory(affiliateId: string, limit = 100) {
    const commissions = await this.prisma.affiliateCommission.findMany({
      where: { affiliateId },
      take: limit,
      orderBy: { createdAt: 'desc' }
    });

    return {
      success: true,
      data: commissions.map((c) => ({
        id: c.id,
        tier: c.tier,
        amount: c.amount,
        status: c.status,
        createdAt: c.createdAt
      }))
    };
  }
}