import { Module } from '@nestjs/common';
import { BullModule } from '@nestjs/bull';
import { AffiliateService } from './affiliate.service';
import { AffiliateController } from './affiliate.controller';
import { DatabaseModule } from '../../database/database.module';

@Module({
  imports: [
    BullModule.registerQueue({ name: 'webhooks' }, { name: 'email' }),
    DatabaseModule
  ],
  providers: [AffiliateService],
  controllers: [AffiliateController]
})
export class AffiliateModule {}