import { Injectable, Logger } from '@nestjs/common';
import { PrismaService } from '../../database/prisma.service';
import { ProductAffiliateLinksService } from './product-links.service';

@Injectable()
export class AutoAffiliateLinkService {
  private logger = new Logger('AutoAffiliateLinkService');

  constructor(
    private prisma: PrismaService,
    private linkService: ProductAffiliateLinksService
  ) {}

  // নতুন প্রোডাক্ট তৈরির সময় স্বয়ংক্রিয় লিংক জেনারেশন
  async autoCreateLinksForNewProduct(tenantId: string, productId: string) {
    try {
      // সব সক্রিয় অ্যাফিলিয়েট পান
      const affiliates = await this.prisma.affiliateAccount.findMany({
        where: {
          tenantId,
          status: 'active',
          isApproved: true
        }
      });

      // প্রতিটি অ্যাফিলিয়েটের জন্য লিংক জেনারেট করুন
      for (const affiliate of affiliates) {
        await this.linkService.generateProductLink(affiliate.id, productId);
      }

      this.logger.log(
        `Auto-created affiliate links for ${affiliates.length} affiliates for product ${productId}`
      );

      return { success: true, linksCreated: affiliates.length };
    } catch (err) {
      this.logger.error('Auto-link creation failed:', err);
      throw err;
    }
  }
}