import { Injectable } from '@nestjs/common';
import { PrismaService } from '../../database/prisma.service';

@Injectable()
export class AffiliateCampaignBuilderService {
  constructor(private prisma: PrismaService) {}

  // এডভান্সড ক্যাম্পেইন টেমপ্লেট
  async getPromotionalTemplates() {
    return {
      templates: [
        {
          id: 'flash_sale',
          name: 'Flash Sale',
          description: 'Limited time offer campaign',
          template: `🔥 LIMITED TIME OFFER! 
          Get {{discount}}% off on {{product}}
          Only {{duration}} hours left!
          👉 {{affiliate_link}}`
        },
        {
          id: 'seasonal',
          name: 'Seasonal Promotion',
          template: `🎉 {{season}} Special!
          Don't miss out on {{product}}
          Hurry, stock is limited!
          Shop now: {{affiliate_link}}`
        },
        {
          id: 'referral_bonus',
          name: 'Referral Bonus',
          template: `💰 Share & Earn!
          Get {{bonus}} for each friend who buys via your link
          {{affiliate_link}}`
        }
      ]
    };
  }

  // ক্যাম্পেইন তৈরি করুন (টেমপ্লেট সহ)
  async createCampaignFromTemplate(
    affiliateId: string,
    templateId: string,
    variables: any
  ) {
    const templates: any = {
      flash_sale: 'Flash Sale Campaign',
      seasonal: 'Seasonal Promotion',
      referral_bonus: 'Referral Bonus'
    };

    const campaignName = templates[templateId] || 'Custom Campaign';

    const campaign = await this.prisma.affiliateCampaign.create({
      data: {
        affiliateId,
        name: campaignName,
        description: `Template: ${templateId}`,
        status: 'draft'
      }
    });

    return { success: true, data: campaign };
  }
}