import { Injectable } from '@nestjs/common';
import { PrismaService } from '../../database/prisma.service';

@Injectable()
export class CommissionConfigService {
  constructor(private prisma: PrismaService) {}

  // গ্লোবাল কমিশন সেট করুন
  async setGlobalCommission(tenantId: string, rate: number) {
    const config = await this.prisma.commissionConfig.upsert({
      where: { tenantId },
      create: {
        tenantId,
        defaultCommissionRate: rate
      },
      update: {
        defaultCommissionRate: rate
      }
    });

    return { success: true, data: config };
  }

  // প্রোডাক্ট-স্পেসিফিক কমিশন সেট করুন
  async setProductCommission(productId: string, rate: number) {
    const override = await this.prisma.productCommissionOverride.upsert({
      where: { productId },
      create: {
        productId,
        commissionRate: rate
      },
      update: {
        commissionRate: rate
      }
    });

    return { success: true, data: override };
  }

  // প্রোডাক্টের জন্য কমিশন রেট পান
  async getCommissionRate(productId: string, tenantId: string): Promise<number> {
    // প্রোডাক্ট-স্পেসিফিক চেক করুন
    const override = await this.prisma.productCommissionOverride.findUnique({
      where: { productId }
    });

    if (override) {
      return Number(override.commissionRate);
    }

    // ডিফল্ট রেট
    const config = await this.prisma.commissionConfig.findUnique({
      where: { tenantId }
    });

    return config ? Number(config.defaultCommissionRate) : 10; // Default 10%
  }

  // কমিশন কনফিগারেশন পান
  async getConfiguration(tenantId: string) {
    const config = await this.prisma.commissionConfig.findUnique({
      where: { tenantId }
    });

    return {
      success: true,
      data: config || {
        defaultCommissionRate: 10,
        perProductEnabled: true,
        minimumPayoutAmount: 100,
        payoutFrequency: 'monthly'
      }
    };
  }
}