import { Injectable } from '@nestjs/common';
import { PrismaService } from '../../database/prisma.service';

@Injectable()
export class MultiRoleAffiliateService {
  constructor(private prisma: PrismaService) {}

  // মাল্টি-রোল অ্যাফিলিয়েট সেটআপ
  async createMultiRoleAffiliate(
    userId: string,
    tenantIds: string[], // Multiple tenants
    roles: string[], // ["user", "admin", "wholesaler"]
    commissionRate: number
  ) {
    const affiliate = await this.prisma.affiliateAccount.create({
      data: {
        userId,
        tenantId: tenantIds[0], // Primary tenant
        role: roles[0],
        commissionRate
      }
    });

    // মাল্টি-টেন্যান্ট সেটআপ রেকর্ড করুন
    await this.prisma.affiliateRoleMapping.create({
      data: {
        affiliateId: affiliate.id,
        roles,
        tenantIds
      }
    });

    return { success: true, data: affiliate };
  }

  // যেকোনো রোল থেকে আয় ক্যালকুলেট করুন
  async getTotalEarningsAcrossRoles(affiliateId: string) {
    const affiliate = await this.prisma.affiliateAccount.findUnique({
      where: { id: affiliateId },
      include: { commissions: true }
    });

    const totalEarnings = affiliate?.commissions
      .filter((c) => c.status === 'paid')
      .reduce((sum, c) => sum + Number(c.amount), 0) || 0;

    return {
      success: true,
      data: {
        affiliateId,
        totalEarnings,
        roles: affiliate?.role
      }
    };
  }
}