import { Injectable } from '@nestjs/common';
import { PrismaService } from '../../database/prisma.service';

@Injectable()
export class ReferralLeaderboardService {
  constructor(private prisma: PrismaService) {}

  // রেফারেল লিডারবোর্ড পান
  async getReferralLeaderboard(tenantId: string, limit = 100) {
    const affiliates = await this.prisma.affiliateAccount.findMany({
      where: { tenantId, status: 'active' },
      include: {
        user: { select: { name: true } }
      }
    });

    // রেফারেল কাউন্ট এবং আর্নিং ক্যালকুলেট করুন
    const leaderboardData = await Promise.all(
      affiliates.map(async (affiliate) => {
        const referrals = await this.prisma.affiliateAccount.count({
          where: { referrerId: affiliate.id }
        });

        const totalEarningsNumber = Number(affiliate.totalEarnings);

        return {
          affiliateId: affiliate.id,
          name: affiliate.user?.name || 'Unknown',
          referrals,
          totalEarnings: totalEarningsNumber,
          conversionRate: affiliate.totalClicks > 0
            ? ((affiliate.totalConversions / affiliate.totalClicks) * 100).toFixed(2)
            : '0'
        };
      })
    );

    // আয় অনুসারে সর্ট করুন
    leaderboardData.sort((a, b) => b.totalEarnings - a.totalEarnings);

    return {
      success: true,
      data: leaderboardData.slice(0, limit).map((item, index) => ({
        rank: index + 1,
        ...item
      }))
    };
  }
}