import { Controller, Post, Get, Body, Param, UseGuards, Req } from '@nestjs/common';
import { ApiTags, ApiBearerAuth } from '@nestjs/swagger';
import { AiService } from './ai.service';
import { JwtAuthGuard } from '../auth/guards/jwt-auth.guard';

@ApiTags('AI')
@Controller('ai')
@UseGuards(JwtAuthGuard)
@ApiBearerAuth()
export class AiController {
  constructor(private aiService: AiService) {}

  @Post('generate/description')
  async generateDescription(@Req() req: any, @Body() body: any) {
    return await this.aiService.generateProductDescription(req.user.tenantId, body);
  }

  @Post('generate/seo')
  async generateSeo(@Req() req: any, @Body() body: any) {
    return await this.aiService.generateSeoMetadata(req.user.tenantId, body);
  }

  @Post('generate/social-post')
  async generateSocialPost(@Req() req: any, @Body() body: any) {
    return await this.aiService.generateSocialPost(req.user.tenantId, body);
  }

  @Post('pricing/suggest')
  async suggestPricing(@Req() req: any, @Body() body: any) {
    return await this.aiService.suggestPricing(req.user.tenantId, body);
  }

  @Post('chatbot')
  async chatbot(@Req() req: any, @Body() body: { message: string; history?: any[] }) {
    return await this.aiService.chatbotResponse(req.user.tenantId, body.message, body.history);
  }

  @Get('trends')
  async getTrends(@Req() req: any) {
    return await this.aiService.detectTrends(req.user.tenantId);
  }

  @Get('inventory/:productId')
  async predictInventory(@Req() req: any, @Param('productId') productId: string) {
    return await this.aiService.predictInventory(req.user.tenantId, productId);
  }
}