import { Injectable } from '@nestjs/common';
import OpenAI from 'openai';

@Injectable()
export class SeoService {
  private openai: OpenAI;

  constructor() {
    this.openai = new OpenAI({ apiKey: process.env.OPENAI_API_KEY });
  }

  // SEO অপ্টিমাইজেশন
  async optimizeForSeo(content: string) {
    const prompt = `
Analyze and optimize this content for SEO:
"${content}"

Return JSON:
{
  "seoScore": 85,
  "suggestions": [
    "Add more keywords in first 100 words",
    "Use more H2 subheadings"
  ],
  "optimizedContent": "improved version",
  "keywords": ["keyword1", "keyword2"]
}
`;

    const response = await this.openai.chat.completions.create({
      model: 'gpt-3.5-turbo',
      messages: [{ role: 'user', content: prompt }],
      temperature: 0.5,
      max_tokens: 500
    });

    const jsonMatch = response.choices[0].message.content?.match(/\{[\s\S]*\}/);
    return jsonMatch ? JSON.parse(jsonMatch[0]) : {};
  }

  // কিওয়ার্ড রিকমেন্ডেশন
  async recommendKeywords(productTitle: string, category: string) {
    const prompt = `
Recommend SEO keywords for:
Product: "${productTitle}"
Category: "${category}"

Return JSON:
{
  "primaryKeywords": ["high volume", "low competition"],
  "longTailKeywords": ["long tail options"],
  "relatedSearches": ["variations"],
  "searchVolume": {"keyword": 1200}
}
`;

    const response = await this.openai.chat.completions.create({
      model: 'gpt-3.5-turbo',
      messages: [{ role: 'user', content: prompt }],
      temperature: 0.6,
      max_tokens: 400
    });

    const jsonMatch = response.choices[0].message.content?.match(/\{[\s\S]*\}/);
    return jsonMatch ? JSON.parse(jsonMatch[0]) : {};
  }
}