import { Injectable, Logger } from '@nestjs/common';
import OpenAI from 'openai';

@Injectable()
export class VoiceCommandService {
  private logger = new Logger('VoiceCommandService');
  private openai: OpenAI;

  constructor() {
    this.openai = new OpenAI({ apiKey: process.env.OPENAI_API_KEY });
  }

  // ভয়েস কমান্ড প্রসেস করুন
  async processCommand(command: string) {
    const prompt = `
Parse this voice command and return the appropriate action:
"${command}"

Return JSON (NO markdown):
{
  "action": "navigate|search|create|update",
  "target": "dashboard|products|orders|analytics",
  "params": {},
  "confirmation": "Tell user what will happen"
}

Common commands:
- "Add a product" → action: create, target: products
- "Show sales chart" → action: navigate, target: analytics
- "List orders" → action: navigate, target: orders
- "Search for shoes" → action: search, params: {query: "shoes"}
`;

    const response = await this.openai.chat.completions.create({
      model: 'gpt-3.5-turbo',
      messages: [{ role: 'user', content: prompt }],
      temperature: 0.5,
      max_tokens: 200
    });

    const jsonMatch = response.choices[0].message.content?.match(/\{[\s\S]*\}/);
    const action = jsonMatch ? JSON.parse(jsonMatch[0]) : {};

    return { success: true, data: action };
  }
}