import {
  Controller,
  Get,
  Query,
  UseGuards,
  Req
} from '@nestjs/common';
import { ApiTags, ApiBearerAuth } from '@nestjs/swagger';
import { AnalyticsService } from './analytics.service';
import { JwtAuthGuard } from '../auth/guards/jwt-auth.guard';

@ApiTags('Analytics')
@Controller('analytics')
@UseGuards(JwtAuthGuard)
@ApiBearerAuth()
export class AnalyticsController {
  constructor(private analyticsService: AnalyticsService) {}

  @Get('revenue')
  async getRevenue(
    @Req() req: any,
    @Query('period') period: 'daily' | 'weekly' | 'monthly' = 'daily'
  ) {
    return await this.analyticsService.getRevenueAnalytics(req.user.tenantId, period);
  }

  @Get('funnel')
  async getFunnel(@Req() req: any) {
    return await this.analyticsService.getConversionFunnel(req.user.tenantId);
  }

  @Get('ltv')
  async getLTV(@Req() req: any) {
    return await this.analyticsService.getCustomerLTV(req.user.tenantId);
  }

  @Get('top-products')
  async getTopProducts(@Req() req: any, @Query('limit') limit = 10) {
    return await this.analyticsService.getTopProducts(req.user.tenantId, limit);
  }

  @Get('traffic')
  async getTraffic(@Req() req: any) {
    return await this.analyticsService.getTrafficAnalytics(req.user.tenantId);
  }

  @Get('heatmap')
  async getHeatmap(@Req() req: any, @Query('pageUrl') pageUrl: string) {
    return await this.analyticsService.getHeatmapData(req.user.tenantId, pageUrl);
  }

  @Get('report/export')
  async exportReport(
    @Req() req: any,
    @Query('format') format: 'csv' | 'pdf' = 'pdf'
  ) {
    return await this.analyticsService.exportReport(req.user.tenantId, format);
  }
}