import { Injectable } from '@nestjs/common';
import { PrismaService } from '../../database/prisma.service';

@Injectable()
export class RealtimeAnalyticsService {
  constructor(private prisma: PrismaService) {}

  // রিয়েল-টাইম ট্রাফিক ডেটা পান
  async getRealtimeTraffic(tenantId: string) {
    const now = new Date();
    const last2Hours = new Date(now.getTime() - 2 * 60 * 60 * 1000);

    const events = await this.prisma.analyticsEvent.findMany({
      where: {
        tenantId,
        createdAt: { gte: last2Hours }
      }
    });

    // ১০ মিনিটের ইন্টারভালে গ্রুপ করুন
    const trafficByTime: any = {};

    events.forEach((event) => {
      const timeKey = new Date(
        Math.floor(event.createdAt.getTime() / (10 * 60 * 1000)) * 10 * 60 * 1000
      ).toLocaleTimeString();

      if (!trafficByTime[timeKey]) {
        trafficByTime[timeKey] = {
          time: timeKey,
          visitors: new Set(),
          pageViews: 0
        };
      }

      if (event.eventType === 'page_view') {
        trafficByTime[timeKey].pageViews++;
      }

      trafficByTime[timeKey].visitors.add(event.sessionId);
    });

    const data = Object.values(trafficByTime).map((item: any) => ({
      ...item,
      visitors: item.visitors.size
    }));

    return { data };
  }
}