import { Injectable, Logger } from '@nestjs/common';
import { PrismaService } from '../../database/prisma.service';
import * as speakeasy from 'speakeasy';

@Injectable()
export class SecurityService {
  private logger = new Logger('SecurityService');

  constructor(private prisma: PrismaService) {}

  // 2FA সেটআপ করুন
  async setupTwoFactor(userId: string) {
    const secret = speakeasy.generateSecret({
      name: `SaaS (${userId})`,
      length: 32
    });

    return { secret: secret.base32, qrCode: secret.otpauth_url };
  }

  // 2FA ভেরিফাই করুন
  async verify2FA(secret: string, token: string): boolean {
    return speakeasy.totp.verify({
      secret,
      encoding: 'base32',
      token,
      window: 2
    });
  }

  // সিকিউরিটি ইভেন্ট লগ করুন
  async logSecurityEvent(
    userId: string,
    eventType: string,
    status: string,
    ipAddress: string,
    userAgent: string
  ) {
    // TODO: Create SecurityEvent model if needed
    this.logger.warn(
      `Security Event: ${eventType} - ${status} by user#${userId} from ${ipAddress}`
    );

    // Alert if suspicious activity
    if (eventType === 'login_failed' && status === 'failed') {
      await this.checkBruteForce(userId, ipAddress);
    }
  }

  // Brute force চেক করুন
  private async checkBruteForce(userId: string, ipAddress: string) {
    // TODO: Implement rate limiting / IP blocking
    // If 5 failed attempts in 15 minutes, block IP temporarily
  }
}