import { Injectable, Logger } from '@nestjs/common';
import { PrismaService } from '../../database/prisma.service';
import { InjectQueue } from '@nestjs/bull';
import { Queue } from 'bull';
import { Cron } from '@nestjs/schedule';

@Injectable()
export class AbandonedCartService {
  private logger = new Logger('AbandonedCartService');

  constructor(
    private prisma: PrismaService,
    @InjectQueue('email') private emailQueue: Queue
  ) {}

  // Abandoned carts চেক করুন (প্রতি ঘণ্টায়)
  @Cron('0 * * * *')
  async checkAbandonedCarts() {
    const tenants = await this.prisma.tenant.findMany({
      where: { status: 'ACTIVE' }
    });

    for (const tenant of tenants) {
      const settings = await this.prisma.checkoutFlow.findUnique({
        where: { tenantId: tenant.id }
      });

      if (!settings?.abandonedCart) continue;

      const delay = settings.abandonedDelay || 60;
      const cutoffTime = new Date(Date.now() - delay * 60 * 1000);

      // TODO: Query abandoned carts from a Cart table
      // Send recovery emails
    }
  }
}