import { Controller, Post, Get, Body, UseGuards, Req, Param, RawBodyRequest } from '@nestjs/common';
import { ApiTags, ApiBearerAuth } from '@nestjs/swagger';
import { BillingService } from './billing.service';
import { JwtAuthGuard } from '../auth/guards/jwt-auth.guard';

@ApiTags('Billing')
@Controller('billing')
export class BillingController {
  constructor(private billingService: BillingService) {}

  @Post('checkout-session')
  @UseGuards(JwtAuthGuard)
  async createCheckoutSession(@Req() req: any, @Body() body: { planType: string }) {
    return await this.billingService.createCheckoutSession(req.user.tenantId, body.planType);
  }

  @Get('subscription')
  @UseGuards(JwtAuthGuard)
  async getSubscription(@Req() req: any) {
    return await this.billingService.getSubscriptionDetails(req.user.tenantId);
  }

  @Post('subscription/cancel')
  @UseGuards(JwtAuthGuard)
  async cancelSubscription(@Req() req: any) {
    return await this.billingService.cancelSubscription(req.user.tenantId);
  }

  @Post('webhook')
  async handleWebhook(@Req() req: RawBodyRequest<Request>, @Body() body: any) {
    const sig = req.headers['stripe-signature'];
    const event = await this.billingService.handleWebhook(body);
    return event;
  }
}