import { Injectable } from '@nestjs/common';
import { PrismaService } from '../../database/prisma.service';

@Injectable()
export class HeaderFooterService {
  constructor(private prisma: PrismaService) {}

  async updateHeader(tenantId: string, input: {
    logoUrl: string;
    navigation: Array<{ label: string; link: string }>;
    ctaButton?: { text: string; link: string };
    sticky: boolean;
  }) {
    const settings = await this.prisma.tenantSettings.findUnique({
      where: { tenantId }
    });

    // Header এ সংরক্ষণ করুন
    // await this.prisma.tenantSettings.update({...})

    return { success: true };
  }

  async updateFooter(tenantId: string, input: {
    columns: Array<{
      title: string;
      links: Array<{ label: string; link: string }>;
    }>;
    social?: Array<{ platform: string; url: string }>;
    copyright: string;
  }) {
    // Footer সংরক্ষণ করুন
    return { success: true };
  }
}