import { Injectable } from '@nestjs/common';

@Injectable()
export class TemplateService {
  // প্রি-বিল্ট টেমপ্লেট
  getTemplates() {
    return [
      {
        id: 'template-1',
        name: 'E-Commerce Minimal',
        type: 'landing',
        description: 'Simple and elegant e-commerce landing page',
        blocks: [
          { type: 'hero', settings: { title: 'Welcome to Our Store' } },
          { type: 'product', settings: { columns: 3 } },
          { type: 'newsletter' },
          { type: 'footer' }
        ]
      },
      {
        id: 'template-2',
        name: 'Fashion Brand',
        type: 'landing',
        description: 'Modern fashion store template',
        blocks: [
          { type: 'hero', settings: { backgroundImage: '', title: 'Latest Collection' } },
          { type: 'product', settings: { columns: 4, showFilter: true } },
          { type: 'banner', settings: { text: 'New Arrivals' } },
          { type: 'newsletter' }
        ]
      },
      {
        id: 'template-3',
        name: 'Tech Store',
        type: 'landing',
        description: 'Technology products showcase',
        blocks: [
          { type: 'hero', settings: {} },
          { type: 'featured', settings: {} },
          { type: 'product', settings: { columns: 3 } },
          { type: 'testimonials' }
        ]
      },
      {
        id: 'template-4',
        name: 'Flash Sale',
        type: 'landing',
        description: 'Limited time offer landing page',
        blocks: [
          { type: 'countdown', settings: {} },
          { type: 'product', settings: { showDiscount: true } },
          { type: 'urgency', settings: { text: 'Only 10 left!' } }
        ]
      },
      {
        id: 'template-5',
        name: 'Minimalist',
        type: 'landing',
        description: 'Clean and minimal design',
        blocks: [
          { type: 'hero' },
          { type: 'text', settings: { align: 'center' } },
          { type: 'product', settings: { columns: 2 } }
        ]
      },
      // আরও 5+ টেমপ্লেট...
    ];
  }

  // কাস্টম টেমপ্লেট সংরক্ষণ করুন
  saveAsTemplate(tenantId: string, pageId: string, templateName: string) {
    // সংরক্ষণের লজিক
  }
}