import { Injectable } from '@nestjs/common';
import { PrismaService } from '../../database/prisma.service';

@Injectable()
export class CheckoutBuilderService {
  constructor(private prisma: PrismaService) {}

  // চেকআউট ফ্লো কাস্টমাইজ করুন
  async customizeCheckout(tenantId: string, input: {
    steps: string[];
    customFields?: any;
    skipSteps?: string[];
  }) {
    const flow = await this.prisma.checkoutFlow.upsert({
      where: { tenantId },
      create: {
        tenantId,
        steps: input.steps,
        customFields: input.customFields
      },
      update: {
        steps: input.steps,
        customFields: input.customFields
      }
    });

    return { success: true, data: flow };
  }

  // Abandoned cart recovery সেটআপ
  async setupAbandonedCartRecovery(
    tenantId: string,
    delayMinutes: number = 60
  ) {
    await this.prisma.checkoutFlow.update({
      where: { tenantId },
      data: {
        abandonedCart: true,
        abandonedDelay: delayMinutes
      }
    });

    return { success: true };
  }
}