import { Injectable } from '@nestjs/common';
import { PrismaService } from '../../database/prisma.service';

@Injectable()
export class GuestCheckoutService {
  constructor(private prisma: PrismaService) {}

  // গেস্ট চেকআউট
  async guestCheckout(input: {
    email: string;
    phone: string;
    name: string;
    address: string;
    cartItems: any[];
    paymentMethod: string;
  }) {
    // অস্থায়ী গেস্ট অর্ডার তৈরি করুন
    const order = await this.prisma.order.create({
      data: {
        tenantId: 'auto-detect',
        userId: 'guest',
        orderNumber: `GUEST-${Date.now()}`,
        guestEmail: input.email,
        guestPhone: input.phone,
        guestName: input.name,
        status: 'PENDING',
        total: input.cartItems.reduce((sum, item) => sum + item.price * item.quantity, 0),
        items: {
          create: input.cartItems
        }
      }
    });

    // পেমেন্ট প্রসেস করুন
    // const payment = await this.processPayment(order.id, input.paymentMethod);

    return { orderId: order.id, success: true };
  }

  // এক্সপ্রেস পে (সংরক্ষিত কার্ড)
  async expressPayWithSavedCard(userId: string, cardId: string, cartItems: any[]) {
    // সংরক্ষিত কার্ড ব্যবহার করে পেমেন্ট
    const order = await this.prisma.order.create({
      data: {
        tenantId: 'auto-detect',
        userId,
        orderNumber: `EXP-${Date.now()}`,
        status: 'PROCESSING',
        total: cartItems.reduce((sum, item) => sum + item.price * item.quantity, 0),
        items: {
          create: cartItems
        }
      }
    });

    return { orderId: order.id, success: true };
  }
}