import { Injectable } from '@nestjs/common';
import { PrismaService } from '../../database/prisma.service';

@Injectable()
export class CustomerGroupService {
  constructor(private prisma: PrismaService) {}

  // গ্রাহক গ্রুপ তৈরি করুন
  async createCustomerGroup(tenantId: string, input: {
    name: string;
    type: 'b2c' | 'b2b' | 'vip' | 'wholesale';
    priceMultiplier: number;
  }) {
    const group = await this.prisma.customerGroup.create({
      data: { tenantId, ...input }
    });

    return { success: true, data: group };
  }
}