import {
  Controller,
  Post,
  Get,
  Put,
  Body,
  Param,
  Query,
  UseGuards,
  Req
} from '@nestjs/common';
import { ApiTags, ApiBearerAuth } from '@nestjs/swagger';
import { EmailMarketingService } from './email-marketing.service';
import { JwtAuthGuard } from '../auth/guards/jwt-auth.guard';

@ApiTags('Email Marketing')
@Controller('email-marketing')
@UseGuards(JwtAuthGuard)
@ApiBearerAuth()
export class EmailMarketingController {
  constructor(private emailMarketingService: EmailMarketingService) {}

  // Campaigns
  @Post('campaigns')
  async createCampaign(@Req() req: any, @Body() dto: any) {
    return await this.emailMarketingService.createCampaign(req.user.tenantId, dto);
  }

  @Get('campaigns')
  async listCampaigns(@Req() req: any, @Query('skip') skip = 0, @Query('take') take = 20) {
    return await this.emailMarketingService.listCampaigns(req.user.tenantId, skip, take);
  }

  @Post('campaigns/:id/send')
  async sendCampaign(@Req() req: any, @Param('id') id: string) {
    return await this.emailMarketingService.sendCampaign(req.user.tenantId, id);
  }

  // Templates
  @Post('templates')
  async createTemplate(@Req() req: any, @Body() dto: any) {
    return await this.emailMarketingService.createEmailTemplate(req.user.tenantId, dto);
  }

  @Get('templates')
  async getTemplates(@Req() req: any) {
    return await this.emailMarketingService.getEmailTemplates(req.user.tenantId);
  }

  // Newsletter
  @Post('newsletter')
  async createNewsletter(@Req() req: any, @Body() dto: any) {
    return await this.emailMarketingService.createNewsletter(req.user.tenantId, dto);
  }

  @Post('subscribe')
  async subscribe(@Req() req: any, @Body() body: { email: string }) {
    return await this.emailMarketingService.subscribeToNewsletter(req.user.tenantId, body.email);
  }

  @Post('unsubscribe')
  async unsubscribe(@Req() req: any, @Body() body: { email: string }) {
    return await this.emailMarketingService.unsubscribeFromNewsletter(req.user.tenantId, body.email);
  }

  @Get('subscribers')
  async listSubscribers(@Req() req: any, @Query('skip') skip = 0, @Query('take') take = 100) {
    return await this.emailMarketingService.listSubscribers(req.user.tenantId, skip, take);
  }

  // Automation
  @Post('workflows')
  async createWorkflow(@Req() req: any, @Body() dto: any) {
    return await this.emailMarketingService.createAutomationWorkflow(req.user.tenantId, dto);
  }

  // Audiences
  @Post('audiences')
  async createAudience(@Req() req: any, @Body() dto: any) {
    return await this.emailMarketingService.createAudience(req.user.tenantId, dto);
  }

  // Analytics
  @Get('campaigns/:id/analytics')
  async getCampaignAnalytics(@Req() req: any, @Param('id') id: string) {
    return await this.emailMarketingService.getCampaignAnalytics(req.user.tenantId, id);
  }

  @Get('analytics/performance')
  async getPerformance(@Req() req: any) {
    return await this.emailMarketingService.getEmailPerformance(req.user.tenantId);
  }
}