import { Injectable } from '@nestjs/common';
import { PrismaService } from '../../database/prisma.service';

@Injectable()
export class ThirdPartyIntegrationService {
  constructor(private prisma: PrismaService) {}

  // Integration সক্রিয় করুন (Facebook Pixel, Google Analytics, TikTok)
  async enableIntegration(tenantId: string, name: string, credentials: any) {
    const integration = await this.prisma.thirdPartyIntegration.upsert({
      where: { tenantId_name: { tenantId, name } },
      create: {
        tenantId,
        name,
        credentials: JSON.stringify(credentials),
        isActive: true
      },
      update: {
        credentials: JSON.stringify(credentials),
        isActive: true
      }
    });

    return { success: true, data: integration };
  }
}