import { Injectable, Logger } from '@nestjs/common';
import { PrismaService } from '../../database/prisma.service';
import { Cron } from '@nestjs/schedule';

@Injectable()
export class ChannelSyncService {
  private logger = new Logger('ChannelSyncService');

  constructor(private prisma: PrismaService) {}

  // সব চ্যানেলে রিয়েল-টাইম ইনভেন্টরি সিঙ্ক করুন
  @Cron('*/5 * * * *') // প্রতি ৫ মিনিটে
  async syncInventoryAcrossChannels() {
    const products = await this.prisma.product.findMany({
      include: { channelInventory: true }
    });

    for (const product of products) {
      // সব চ্যানেলের স্টক যোগ করুন
      const totalStock = product.channelInventory.reduce(
        (sum, inv) => sum + inv.stock,
        0
      );

      // মেইন প্রোডাক্ট স্টক আপডেট করুন
      await this.prisma.product.update({
        where: { id: product.id },
        data: { stock: totalStock }
      });

      // কম স্টকের জন্য রিঅর্ডার করুন
      if (totalStock < (product.reorderLevel || 10)) {
        await this.triggerReorder(product.id);
      }

      this.logger.log(`Inventory synced for ${product.title}: ${totalStock} units`);
    }
  }

  private async triggerReorder(productId: string) {
    // সাপ্লায়ারকে অটো রিঅর্ডার রিকোয়েস্ট পাঠান
    this.logger.log(`Reorder triggered for product ${productId}`);
  }
}