import { Injectable } from '@nestjs/common';
import geoip from 'geoip-lite';

@Injectable()
export class LocaleService {
  // ব্যবহারকারীর লোকেশন থেকে কারেন্সি ডিটেক্ট করুন
  detectCurrency(ipAddress: string): string {
    const geo = geoip.lookup(ipAddress);

    const currencyMap: any = {
      BD: 'BDT',
      IN: 'INR',
      PK: 'PKR',
      US: 'USD',
      GB: 'GBP',
      AU: 'AUD',
      CA: 'CAD',
      // আরও দেশ...
    };

    return currencyMap[geo?.country] || 'USD';
  }

  // ব্রাউজার ভাষা থেকে ভাষা ডিটেক্ট করুন
  detectLanguage(acceptLanguageHeader: string): string {
    const languages = acceptLanguageHeader.split(',')[0].split('-')[0];

    const langMap: any = {
      en: 'en',
      bn: 'bn',
      hi: 'hi',
      ar: 'ar',
      es: 'es',
      fr: 'fr',
      de: 'de'
    };

    return langMap[languages] || 'en';
  }
}