import {
  Controller,
  Post,
  Get,
  Body,
  UseGuards,
  Req
} from '@nestjs/common';
import { ApiTags, ApiBearerAuth } from '@nestjs/swagger';
import { MarketingService } from './marketing.service';
import { JwtAuthGuard } from '../auth/guards/jwt-auth.guard';

@ApiTags('Marketing')
@Controller('marketing')
@UseGuards(JwtAuthGuard)
@ApiBearerAuth()
export class MarketingController {
  constructor(private marketingService: MarketingService) {}

  @Post('abandoned-cart-recovery')
  async triggerAbandonedCart(@Req() req: any) {
    return await this.marketingService.triggerAbandonedCartRecovery(req.user.tenantId);
  }

  @Post('campaign')
  async createCampaign(@Req() req: any, @Body() dto: any) {
    return await this.marketingService.createCampaign(req.user.tenantId, dto);
  }

  @Post('sms')
  async sendSMS(@Req() req: any, @Body() body: { phoneNumber: string; message: string }) {
    return await this.marketingService.sendSMS(req.user.tenantId, body.phoneNumber, body.message);
  }

  @Post('push-notification')
  async sendPushNotification(@Req() req: any, @Body() dto: any) {
    return await this.marketingService.sendPushNotification(req.user.tenantId, dto);
  }

  @Get('insights')
  async getInsights(@Req() req: any) {
    return await this.marketingService.getMarketingInsights(req.user.tenantId);
  }
}