import { Module } from '@nestjs/common';
import { BullModule } from '@nestjs/bull';
import { MarketingService } from './marketing.service';
import { MarketingController } from './marketing.controller';
import { DatabaseModule } from '../../database/database.module';

@Module({
  imports: [
    BullModule.registerQueue({ name: 'email' }),
    DatabaseModule
  ],
  providers: [MarketingService],
  controllers: [MarketingController]
})
export class MarketingModule {}