import { Controller, Get, UseGuards, Req, Query } from '@nestjs/common';
import { ApiTags, ApiBearerAuth } from '@nestjs/swagger';
import { MeteringService } from './metering.service';
import { JwtAuthGuard } from '../auth/guards/jwt-auth.guard';

@ApiTags('Metering')
@Controller('metering')
@UseGuards(JwtAuthGuard)
@ApiBearerAuth()
export class MeteringController {
  constructor(private meteringService: MeteringService) {}

  // কী: রিয়েল-টাইম ব্যবহার দেখুন
  @Get('usage')
  async getUsage(@Req() req: any, @Query('month') month?: string) {
    return await this.meteringService.getUsageReport(req.user.tenantId, month);
  }
}