import { Module } from '@nestjs/common';
import { BullModule } from '@nestjs/bull';
import { OrderService } from './order.service';
import { OrderController } from './order.controller';
import { DatabaseModule } from '../../database/database.module';

@Module({
  imports: [
    BullModule.registerQueue({ name: 'email' }, { name: 'webhooks' }),
    DatabaseModule
  ],
  providers: [OrderService],
  controllers: [OrderController]
})
export class OrderModule {}