import { Injectable } from '@nestjs/common';
import { PrismaService } from '../../database/prisma.service';

@Injectable()
export class CategoryFilterService {
  constructor(private prisma: PrismaService) {}

  // ক্যাটেগরি হায়ারার্কি পান
  async getCategoryHierarchy(tenantId: string) {
    const categories = await this.prisma.productCategory.findMany({
      where: { tenantId, parentId: null }, // শুধু টপ-লেভেল
      include: {
        children: {
          include: {
            children: true // নেস্টেড ক্যাটেগরি
          }
        }
      }
    });

    return { categories };
  }

  // ব্র্যান্ড ফিল্টার পান
  async getBrands(tenantId: string) {
    const brands = await this.prisma.product.findMany({
      where: { tenantId },
      distinct: ['brand'],
      select: { brand: true }
    });

    return {
      brands: brands
        .map((p) => p.brand)
        .filter((b) => b !== null)
        .sort()
    };
  }

  // ক্যাটেগরি-ভিত্তিক প্রোডাক্ট পান
  async getProductsByCategory(tenantId: string, categoryId: string, limit = 20) {
    const products = await this.prisma.product.findMany({
      where: { tenantId, categoryId },
      take: limit,
      include: { category: true }
    });

    return { products };
  }
}