import { Injectable } from '@nestjs/common';
import { PrismaService } from '../../database/prisma.service';

@Injectable()
export class CompareWishlistService {
  constructor(private prisma: PrismaService) {}

  // উইশলিস্ট যোগ করুন
  async addToWishlist(userId: string, productId: string) {
    const item = await this.prisma.wishlistItem.create({
      data: { userId, productId }
    });

    return { success: true, data: item };
  }

  // উইশলিস্ট সরান
  async removeFromWishlist(userId: string, productId: string) {
    await this.prisma.wishlistItem.delete({
      where: {
        userId_productId: { userId, productId }
      }
    });

    return { success: true };
  }

  // উইশলিস্ট পান
  async getWishlist(userId: string) {
    const wishlist = await this.prisma.wishlistItem.findMany({
      where: { userId },
      include: { product: true }
    });

    return { items: wishlist };
  }

  // প্রোডাক্ট তুলনা করুন
  async compareProducts(productIds: string[]) {
    const products = await this.prisma.product.findMany({
      where: { id: { in: productIds } }
    });

    // বৈশিষ্ট্য তুলনা করুন
    return {
      products: products.map((p) => ({
        id: p.id,
        title: p.title,
        price: p.price,
        stock: p.stock,
        description: p.description,
        images: p.images
      }))
    };
  }
}