import { Injectable } from '@nestjs/common';
import { PrismaService } from '../../database/prisma.service';

@Injectable()
export class PricingService {
  constructor(private prisma: PrismaService) {}

  // মার্জিন রুল সেট করুন
  async setMarginRule(tenantId: string, input: {
    categoryId?: string;
    minPrice: number;
    maxPrice: number;
    marginPercentage: number;
  }) {
    // মার্জিন রুল সংরক্ষণ করুন
    // TODO: Create PricingRule model

    return { success: true };
  }

  // প্রোডাক্ট প্রাইস আপডেট করুন (স্টক ভিত্তিক)
  async updatePriceByStock(productId: string) {
    const product = await this.prisma.product.findUnique({
      where: { id: productId }
    });

    if (!product) return;

    // স্টক কম হলে প্রাইস বাড়ান
    let newPrice = product.price;

    if (product.stock < 5) {
      newPrice = product.price * 1.15; // 15% বেশি
    } else if (product.stock > 100) {
      newPrice = product.price * 0.95; // 5% কম
    }

    await this.prisma.product.update({
      where: { id: productId },
      data: { price: newPrice }
    });

    return { success: true, newPrice };
  }

  // স্টক ম্যানেজমেন্ট
  async updateStock(productId: string, quantity: number) {
    await this.prisma.product.update({
      where: { id: productId },
      data: { stock: quantity }
    });

    return { success: true };
  }
}