import { Controller, Post, UseGuards, Body, Req } from '@nestjs/common';
import { Roles } from '../../common/guards/rbac.guard';
import { RolesGuard } from '../../common/guards/rbac.guard';
import { JwtAuthGuard } from '../auth/guards/jwt-auth.guard';

@Controller('products')
@UseGuards(JwtAuthGuard, RolesGuard)
export class ProductController {
  // শুধু ADMIN ও তার উপরে রোল পারবে
  @Post()
  @Roles('ADMIN', 'SUPER_ADMIN')
  async createProduct(@Req() req: any, @Body() dto: any) {
    // Only admin-level users
  }

  // MANAGER এবং তার উপরে
  @Post('bulk-import')
  @Roles('ADMIN', 'SUPER_ADMIN', 'MANAGER')
  async bulkImport(@Req() req: any, @Body() body: any) {
    // Staff and below cannot import
  }

  // সবাই পড়তে পারে (পাবলিক)
  @Get()
  async listProducts() {
    // No roles required
  }
}