import { Injectable, Logger } from '@nestjs/common';
import { PrismaService } from '../../database/prisma.service';

@Injectable()
export class ProductQAService {
  private logger = new Logger('ProductQAService');

  constructor(private prisma: PrismaService) {}

  // প্রশ্ন জমা দিন
  async submitQuestion(productId: string, question: string, askedBy: string) {
    const qa = await this.prisma.productQnA.create({
      data: {
        productId,
        question,
        askedBy,
        status: 'pending'
      }
    });

    this.logger.log(`Question submitted for product ${productId}`);

    return { success: true, data: qa };
  }

  // প্রশ্নের উত্তর দিন (অ্যাডমিন)
  async answerQuestion(qaId: string, answer: string, adminId: string) {
    const qa = await this.prisma.productQnA.update({
      where: { id: qaId },
      data: {
        answer,
        answeredBy: adminId,
        status: 'answered',
        answeredAt: new Date()
      }
    });

    return { success: true, data: qa };
  }

  // পণ্যের Q&A পান
  async getProductQnA(productId: string, limit = 10) {
    const qnas = await this.prisma.productQnA.findMany({
      where: {
        productId,
        status: 'answered'
      },
      orderBy: { upvotes: 'desc' },
      take: limit
    });

    return { qnas };
  }

  // উপকারী মার্ক করুন
  async markAsHelpful(qaId: string) {
    await this.prisma.productQnA.update({
      where: { id: qaId },
      data: { upvotes: { increment: 1 } }
    });

    return { success: true };
  }
}