import { Injectable } from '@nestjs/common';
import { PrismaService } from '../../database/prisma.service';

@Injectable()
export class RecentlyViewedService {
  constructor(private prisma: PrismaService) {}

  // প্রোডাক্ট ভিউ রেকর্ড করুন
  async recordView(userId: string, productId: string) {
    await this.prisma.recentlyViewed.upsert({
      where: { userId_productId: { userId, productId } },
      create: { userId, productId },
      update: { viewedAt: new Date() }
    });
  }

  // সম্প্রতি দেখা পণ্য পান
  async getRecentlyViewed(userId: string, limit = 10) {
    const viewed = await this.prisma.recentlyViewed.findMany({
      where: { userId },
      include: { product: true },
      orderBy: { viewedAt: 'desc' },
      take: limit
    });

    return { products: viewed.map((v) => v.product) };
  }
}