import { Injectable } from '@nestjs/common';
import { PrismaService } from '../../database/prisma.service';

@Injectable()
export class PromoService {
  constructor(private prisma: PrismaService) {}

  // কুপন যাচাই করুন
  async validateCoupon(code: string, amount: number) {
    const coupon = await this.prisma.coupon.findUnique({
      where: { code }
    });

    if (!coupon) return { valid: false, message: 'Coupon not found' };
    if (new Date() > coupon.validTo) return { valid: false, message: 'Coupon expired' };
    if (coupon.currentUses >= (coupon.maxUses || Infinity)) {
      return { valid: false, message: 'Coupon limit reached' };
    }

    // ডিসকাউন্ট ক্যালকুলেট করুন
    const discount =
      coupon.discountType === 'percentage'
        ? (amount * Number(coupon.discountPercent)) / 100
        : Number(coupon.discountPercent);

    return {
      valid: true,
      discount,
      finalAmount: amount - discount
    };
  }

  // পয়েন্ট রিডিম করুন
  async redeemPoints(userId: string, tenantId: string, points: number) {
    const pointsBalance = await this.prisma.customerPoints.findUnique({
      where: { userId_tenantId: { userId, tenantId } }
    });

    if (!pointsBalance || pointsBalance.totalPoints < points) {
      throw new Error('Insufficient points');
    }

    // পয়েন্ট রিডিম করুন
    await this.prisma.customerPoints.update({
      where: { userId_tenantId: { userId, tenantId } },
      data: { redeemedPoints: { increment: points } }
    });

    return { success: true };
  }

  // ক্যাশব্যাক হিসাব করুন
  async calculateCashback(amount: number, percentage: number) {
    return (amount * percentage) / 100;
  }
}