import { Injectable } from '@nestjs/common';
import { PrismaService } from '../../database/prisma.service';
import OpenAI from 'openai';

@Injectable()
export class AISearchService {
  private openai: OpenAI;

  constructor(private prisma: PrismaService) {
    this.openai = new OpenAI({ apiKey: process.env.OPENAI_API_KEY });
  }

  // AI-পাওয়ারড স্মার্ট সার্চ
  async smartSearch(query: string, tenantId: string) {
    // প্রশ্ন বুঝতে AI ব্যবহার করুন
    const embedding = await this.getEmbedding(query);

    // সিমিলার প্রোডাক্ট খুঁজুন (Vector similarity)
    const results = await this.prisma.product.findMany({
      where: { tenantId },
      take: 10
      // TODO: Implement vector similarity search
    });

    // স্মার্ট ফিল্টারিং (প্রাইস, ক্যাটাগরি, ইত্যাদি)
    const filtered = this.applySmartFilters(results, query);

    return filtered;
  }

  // ন্যাচারাল ল্যাঙ্গুয়েজ কোয়েরি (যেমন "লাল শার্ট কিন্তু ৫০০ টাকার নিচে")
  async naturalLanguageSearch(query: string, tenantId: string) {
    const response = await this.openai.chat.completions.create({
      model: 'gpt-3.5-turbo',
      messages: [
        {
          role: 'system',
          content: `Extract search parameters from user query. Return JSON with: 
            { keyword: string, minPrice: number, maxPrice: number, colors: array, categories: array }`
        },
        { role: 'user', content: query }
      ]
    });

    const params = JSON.parse(response.choices[0].message.content || '{}');

    // প্যারামিটার অনুযায়ী প্রোডাক্ট খুঁজুন
    const products = await this.prisma.product.findMany({
      where: {
        tenantId,
        AND: [
          { title: { contains: params.keyword, mode: 'insensitive' } },
          { price: { gte: params.minPrice || 0, lte: params.maxPrice || 999999 } }
        ]
      }
    });

    return products;
  }

  private async getEmbedding(text: string): Promise<number[]> {
    // OpenAI embedding API
    // return vector embedding
    return [];
  }

  private applySmartFilters(results: any[], query: string): any[] {
    // স্মার্ট ফিল্টারিং লজিক
    return results;
  }
}