import { Injectable } from '@nestjs/common';
import { PrismaService } from '../../database/prisma.service';

@Injectable()
export class SchemaMarkupService {
  constructor(private prisma: PrismaService) {}

  // প্রোডাক্টের জন্য Schema তৈরি করুন
  async generateProductSchema(
    tenantId: string,
    product: any
  ) {
    const schema = {
      '@context': 'https://schema.org',
      '@type': 'Product',
      name: product.title,
      description: product.description,
      image: product.images,
      brand: {
        '@type': 'Brand',
        name: product.brand || 'Unknown'
      },
      offers: {
        '@type': 'Offer',
        price: product.price,
        priceCurrency: product.currency || 'USD',
        availability: product.stock > 0 ? 'InStock' : 'OutOfStock',
        url: product.url
      },
      aggregateRating: {
        '@type': 'AggregateRating',
        ratingValue: product.rating || 0,
        reviewCount: product.reviewCount || 0
      }
    };

    await this.prisma.schemaMarkup.upsert({
      where: {
        tenantId_pageUrl: {
          tenantId,
          pageUrl: product.url
        }
      },
      create: {
        tenantId,
        pageUrl: product.url,
        schemaType: 'Product',
        schemaData: schema
      },
      update: {
        schemaData: schema
      }
    });

    return schema;
  }

  // সব Schema পান
  async getSchemas(tenantId: string) {
    return this.prisma.schemaMarkup.findMany({
      where: { tenantId }
    });
  }
}