import { Controller, Post, Get, Body, UseGuards, Req } from '@nestjs/common';
import { PrismaService } from '../../database/prisma.service';
import { JwtAuthGuard } from '../auth/guards/jwt-auth.guard';
import { Roles } from '../../common/guards/rbac.guard';

@Controller('settings/maintenance')
@UseGuards(JwtAuthGuard)
export class MaintenanceController {
  constructor(private prisma: PrismaService) {}

  @Get()
  async getMaintenanceStatus(@Req() req: any) {
    const settings = await this.prisma.tenantSettings.findUnique({
      where: { tenantId: req.user.tenantId }
    });

    return {
      maintenanceMode: settings?.maintenanceMode || false,
      maintenanceText: settings?.maintenanceText || ''
    };
  }

  @Post()
  @Roles('ADMIN', 'SUPER_ADMIN')
  async setMaintenanceMode(
    @Req() req: any,
    @Body() body: { enabled: boolean; message: string }
  ) {
    await this.prisma.tenantSettings.update({
      where: { tenantId: req.user.tenantId },
      data: {
        maintenanceMode: body.enabled,
        maintenanceText: body.message
      }
    });

    return { success: true };
  }
}