import { Injectable } from '@nestjs/common';
import { PrismaService } from '../../database/prisma.service';

@Injectable()
export class ShippingRulesService {
  constructor(private prisma: PrismaService) {}

  // শিপিং রুল তৈরি করুন
  async createShippingRule(tenantId: string, input: {
    name: string;
    countries: string[];
    baseCost: number;
    costPerKg?: number;
    defaultCourier?: string;
  }) {
    const rule = await this.prisma.shippingRule.create({
      data: {
        tenantId,
        name: input.name,
        countries: input.countries,
        baseCost: input.baseCost,
        costPerKg: input.costPerKg,
        defaultCourier: input.defaultCourier
      }
    });

    return { success: true, data: rule };
  }

  // শিপিং খরচ ক্যালকুলেট করুন
  async calculateShippingCost(
    tenantId: string,
    country: string,
    weight: number
  ): Promise<number> {
    const rule = await this.prisma.shippingRule.findFirst({
      where: {
        tenantId,
        countries: { has: country }
      }
    });

    if (!rule) return 0;

    return Number(rule.baseCost) + (rule.costPerKg ? weight * Number(rule.costPerKg) : 0);
  }
}