import { Module, OnModuleInit } from '@nestjs/common';
import { CourierService } from './courier.service';
import { ShippingController } from './shipping.controller';
import { DatabaseModule } from '../../database/database.module';

@Module({
  imports: [DatabaseModule],
  providers: [CourierService],
  controllers: [ShippingController],
  exports: [CourierService]
})
export class ShippingModule implements OnModuleInit {
  constructor(private courierService: CourierService) {}

  async onModuleInit() {
    // Initialize couriers on startup
    await this.courierService.initializeCouriers();
  }
}