import { Injectable } from '@nestjs/common';
import { PrismaService } from '../../database/prisma.service';

@Injectable()
export class WholesaleShippingService {
  constructor(private prisma: PrismaService) {}

  // বাল্ক অর্ডারের জন্য শিপিং রেট পান
  async getShippingRateForBulkOrder(
    orderId: string,
    destination: {
      city: string;
      state: string;
      country: string;
      zipCode: string;
    },
    totalWeight: number
  ) {
    const order = await this.prisma.order.findUnique({
      where: { id: orderId }
    });

    if (!order) throw new Error('Order not found');

    // শিপিং রেট ক্যালকুলেট করুন (বড় অর্ডারে ডিসকাউন্ট)
    const baseRate = 50; // Base shipping rate
    const weightRate = totalWeight * 2;

    let totalRate = baseRate + weightRate;

    // বাল্ক ডিসকাউন্ট
    if (order.total > 5000) {
      totalRate = totalRate * 0.8; // 20% ছাড়
    } else if (order.total > 2000) {
      totalRate = totalRate * 0.9; // 10% ছাড়
    }

    return {
      shippingRate: totalRate,
      estimatedDays: 3
    };
  }
}