import { Injectable } from '@nestjs/common';
import { PrismaService } from '../../database/prisma.service';

@Injectable()
export class BillingOverviewService {
  constructor(private prisma: PrismaService) {}

  // সব টেন্যান্টের বিলিং দেখুন
  async getBillingOverview() {
    const tenants = await this.prisma.tenant.findMany({
      include: {
        subscription: true
      }
    });

    const billingData = tenants.map((tenant) => ({
      tenantId: tenant.id,
      name: tenant.name,
      plan: tenant.subscription?.plan || 'none',
      status: tenant.subscription?.status || 'inactive',
      monthlyRecurring: tenant.subscription?.monthlyPrice || 0,
      nextBillingDate: tenant.subscription?.nextBillingDate,
      totalPaid: 0 // Calculate from payments
    }));

    return {
      totalTenants: tenants.length,
      billingData,
      totalRecurringRevenue: billingData.reduce(
        (sum, b) => sum + b.monthlyRecurring,
        0
      )
    };
  }

  // টেন্যান্ট বিলিং ইতিহাস
  async getTenantBillingHistory(tenantId: string) {
    const payments = await this.prisma.payment.findMany({
      where: { tenantId },
      orderBy: { createdAt: 'desc' }
    });

    return payments;
  }

  // ম্যানুয়াল চার্জ/রিফান্ড
  async manualChargeOrRefund(
    tenantId: string,
    amount: number,
    type: 'charge' | 'refund',
    reason: string
  ) {
    const transaction = {
      tenantId,
      amount,
      type,
      reason,
      createdAt: new Date()
    };

    // TODO: Record in payment system

    return { success: true, transaction };
  }
}