export const PREMIUM_THEMES = [
  // =================== MODERN THEMES (5) ===================
  {
    id: 'modern-minimal',
    name: 'Modern Minimal',
    category: 'modern',
    description: 'Clean, minimalist design with maximum usability',
    colors: {
      primary: '#000000',
      secondary: '#FFFFFF',
      accent: '#0066FF',
      text: '#1a1a1a',
      background: '#FFFFFF',
      border: '#E5E5E5',
      success: '#22C55E',
      warning: '#F59E0B',
      error: '#EF4444'
    },
    fonts: {
      headings: { family: 'Inter, sans-serif', weight: 700, size: '32px' },
      body: { family: 'Inter, sans-serif', weight: 400, size: '16px' },
      mono: { family: 'Courier New, monospace', weight: 400, size: '14px' }
    },
    components: {
      button: { radius: '4px', padding: '10px 20px', shadow: 'none' },
      card: { radius: '8px', shadow: '0 1px 3px rgba(0,0,0,0.1)' },
      navbar: { height: '64px', shadow: 'light' }
    }
  },

  {
    id: 'glassmorphism',
    name: 'Glassmorphism',
    category: 'modern',
    description: 'Modern glass effect with blur and transparency',
    colors: {
      primary: '#FFFFFF',
      secondary: '#F0F4FF',
      accent: '#6366F1',
      text: '#1E293B',
      background: '#0F172A',
      border: 'rgba(255,255,255,0.1)',
      success: '#10B981',
      warning: '#F59E0B',
      error: '#EF4444'
    },
    fonts: {
      headings: { family: 'Poppins, sans-serif', weight: 600, size: '36px' },
      body: { family: 'Inter, sans-serif', weight: 400, size: '16px' },
      mono: { family: 'JetBrains Mono, monospace', weight: 400, size: '13px' }
    },
    components: {
      button: { radius: '12px', padding: '12px 24px', shadow: '0 8px 32px rgba(99,102,241,0.2)', backdrop: 'blur' },
      card: { radius: '16px', shadow: '0 8px 32px rgba(0,0,0,0.1)', backdrop: 'blur(10px)' },
      navbar: { height: '70px', shadow: '0 8px 32px rgba(0,0,0,0.1)', backdrop: 'blur(10px)' }
    }
  },

  {
    id: 'neumorphism',
    name: 'Neumorphism',
    category: 'modern',
    description: 'Soft shadows and subtle elevations',
    colors: {
      primary: '#E0E5EC',
      secondary: '#FFFFFF',
      accent: '#6C5CE7',
      text: '#2D3436',
      background: '#E0E5EC',
      border: '#D3D8E8',
      success: '#00B894',
      warning: '#FDCB6E',
      error: '#D63031'
    },
    fonts: {
      headings: { family: 'Segoe UI, sans-serif', weight: 700, size: '32px' },
      body: { family: 'Segoe UI, sans-serif', weight: 400, size: '16px' },
      mono: { family: 'Fira Code, monospace', weight: 400, size: '14px' }
    },
    components: {
      button: { radius: '50px', padding: '12px 28px', shadow: '0 10px 20px rgba(0,0,0,0.1)' },
      card: { radius: '20px', shadow: '0 5px 15px rgba(0,0,0,0.08)' },
      navbar: { height: '70px', shadow: '0 5px 15px rgba(0,0,0,0.08)' }
    }
  },

  {
    id: 'brutalism',
    name: 'Brutalism',
    category: 'modern',
    description: 'Bold, raw design with strong typography',
    colors: {
      primary: '#1A1A1A',
      secondary: '#FFFFFF',
      accent: '#FFD700',
      text: '#000000',
      background: '#F5F5F5',
      border: '#000000',
      success: '#33CC33',
      warning: '#FF9900',
      error: '#CC0000'
    },
    fonts: {
      headings: { family: 'IBM Plex Serif, serif', weight: 700, size: '48px' },
      body: { family: 'IBM Plex Sans, sans-serif', weight: 400, size: '16px' },
      mono: { family: 'IBM Plex Mono, monospace', weight: 400, size: '14px' }
    },
    components: {
      button: { radius: '0px', padding: '15px 30px', shadow: 'none', border: '2px solid #000' },
      card: { radius: '0px', shadow: 'none', border: '1px solid #000' },
      navbar: { height: '80px', shadow: 'none', border: '2px solid #000' }
    }
  },

  {
    id: 'vibrant-neon',
    name: 'Vibrant Neon',
    category: 'modern',
    description: 'Bold and colorful with neon accents',
    colors: {
      primary: '#FF006E',
      secondary: '#08F7FE',
      accent: '#00F5FF',
      text: '#FFFFFF',
      background: '#0A0E27',
      border: '#FF006E',
      success: '#39FF14',
      warning: '#FFFD38',
      error: '#FF006E'
    },
    fonts: {
      headings: { family: 'Space Mono, monospace', weight: 700, size: '36px' },
      body: { family: 'Roboto, sans-serif', weight: 400, size: '16px' },
      mono: { family: 'Space Mono, monospace', weight: 400, size: '14px' }
    },
    components: {
      button: { radius: '8px', padding: '12px 24px', shadow: '0 0 20px rgba(255,0,110,0.5)' },
      card: { radius: '12px', shadow: '0 0 30px rgba(0,245,255,0.3)' },
      navbar: { height: '70px', shadow: '0 0 30px rgba(255,0,110,0.2)' }
    }
  },

  // =================== LUXURY THEMES (4) ===================
  {
    id: 'luxury-gold',
    name: 'Luxury Gold',
    category: 'luxury',
    description: 'Premium gold and black luxury design',
    colors: {
      primary: '#1A1A1A',
      secondary: '#FFFFFF',
      accent: '#D4AF37',
      text: '#1A1A1A',
      background: '#FFFFFF',
      border: '#D4AF37',
      success: '#22C55E',
      warning: '#F59E0B',
      error: '#EF4444'
    },
    fonts: {
      headings: { family: 'Playfair Display, serif', weight: 700, size: '48px' },
      body: { family: 'Lato, sans-serif', weight: 300, size: '16px' },
      mono: { family: 'Courier Prime, monospace', weight: 400, size: '14px' }
    },
    components: {
      button: { radius: '2px', padding: '14px 32px', shadow: '0 4px 15px rgba(212,175,55,0.2)' },
      card: { radius: '4px', shadow: '0 4px 15px rgba(0,0,0,0.1)' },
      navbar: { height: '80px', shadow: '0 4px 15px rgba(212,175,55,0.1)' }
    }
  },

  {
    id: 'premium-black',
    name: 'Premium Black',
    category: 'luxury',
    description: 'High-end black with rose gold accents',
    colors: {
      primary: '#0A0A0A',
      secondary: '#FFFFFF',
      accent: '#C0A080',
      text: '#FFFFFF',
      background: '#0A0A0A',
      border: '#C0A080',
      success: '#00D084',
      warning: '#FFB84D',
      error: '#FF4D4D'
    },
    fonts: {
      headings: { family: 'Montserrat, sans-serif', weight: 700, size: '44px' },
      body: { family: 'Open Sans, sans-serif', weight: 400, size: '16px' },
      mono: { family: 'Inconsolata, monospace', weight: 400, size: '14px' }
    },
    components: {
      button: { radius: '25px', padding: '13px 28px', shadow: '0 8px 24px rgba(192,160,128,0.15)' },
      card: { radius: '12px', shadow: '0 8px 24px rgba(192,160,128,0.1)' },
      navbar: { height: '72px', shadow: '0 8px 24px rgba(192,160,128,0.1)' }
    }
  },

  {
    id: 'elegant-dark',
    name: 'Elegant Dark',
    category: 'luxury',
    description: 'Sophisticated dark theme with elegant accents',
    colors: {
      primary: '#1F1F1F',
      secondary: '#FFFFFF',
      accent: '#FFD700',
      text: '#E8E8E8',
      background: '#0D0D0D',
      border: '#404040',
      success: '#4CAF50',
      warning: '#FF9800',
      error: '#F44336'
    },
    fonts: {
      headings: { family: 'Georgia, serif', weight: 700, size: '40px' },
      body: { family: 'Helvetica Neue, sans-serif', weight: 400, size: '16px' },
      mono: { family: 'Monaco, monospace', weight: 400, size: '14px' }
    },
    components: {
      button: { radius: '6px', padding: '12px 24px', shadow: '0 6px 20px rgba(255,215,0,0.25)' },
      card: { radius: '8px', shadow: '0 6px 20px rgba(0,0,0,0.3)' },
      navbar: { height: '68px', shadow: '0 6px 20px rgba(0,0,0,0.3)' }
    }
  },

  {
    id: 'rose-gold',
    name: 'Rose Gold',
    category: 'luxury',
    description: 'Elegant rose gold luxury theme',
    colors: {
      primary: '#2D1B1B',
      secondary: '#FFFAF0',
      accent: '#B76B7F',
      text: '#3E2C2C',
      background: '#FFFAF0',
      border: '#E8D4D8',
      success: '#6B8E7F',
      warning: '#D4A574',
      error: '#C85A54'
    },
    fonts: {
      headings: { family: 'Bodoni Moda, serif', weight: 700, size: '42px' },
      body: { family: 'Cormorant Garamond, serif', weight: 300, size: '16px' },
      mono: { family: 'Courier New, monospace', weight: 400, size: '14px' }
    },
    components: {
      button: { radius: '20px', padding: '12px 30px', shadow: '0 4px 15px rgba(183,107,127,0.2)' },
      card: { radius: '12px', shadow: '0 4px 15px rgba(183,107,127,0.1)' },
      navbar: { height: '70px', shadow: '0 4px 15px rgba(183,107,127,0.1)' }
    }
  },

  // =================== E-COMMERCE THEMES (6) ===================
  {
    id: 'fashion-pro',
    name: 'Fashion Pro',
    category: 'ecommerce',
    description: 'Perfect for fashion and apparel stores',
    colors: {
      primary: '#222222',
      secondary: '#FFFFFF',
      accent: '#E91E63',
      text: '#333333',
      background: '#FAFAFA',
      border: '#E0E0E0',
      success: '#4CAF50',
      warning: '#FF9800',
      error: '#F44336'
    },
    fonts: {
      headings: { family: 'Bebas Neue, sans-serif', weight: 400, size: '36px' },
      body: { family: 'Raleway, sans-serif', weight: 400, size: '15px' },
      mono: { family: 'Courier New, monospace', weight: 400, size: '14px' }
    },
    components: {
      button: { radius: '2px', padding: '12px 28px', shadow: 'none' },
      card: { radius: '0px', shadow: '0 2px 8px rgba(0,0,0,0.1)' },
      navbar: { height: '72px', shadow: '0 2px 8px rgba(0,0,0,0.1)' }
    }
  },

  {
    id: 'grocery-fresh',
    name: 'Grocery Fresh',
    category: 'ecommerce',
    description: 'Fresh and vibrant for grocery and food stores',
    colors: {
      primary: '#22C55E',
      secondary: '#FFFFFF',
      accent: '#F59E0B',
      text: '#1F2937',
      background: '#F9FAFB',
      border: '#E5E7EB',
      success: '#10B981',
      warning: '#F59E0B',
      error: '#EF4444'
    },
    fonts: {
      headings: { family: 'Poppins, sans-serif', weight: 700, size: '36px' },
      body: { family: 'Inter, sans-serif', weight: 400, size: '16px' },
      mono: { family: 'Roboto Mono, monospace', weight: 400, size: '14px' }
    },
    components: {
      button: { radius: '8px', padding: '12px 24px', shadow: '0 4px 12px rgba(34,197,94,0.2)' },
      card: { radius: '12px', shadow: '0 4px 12px rgba(34,197,94,0.1)' },
      navbar: { height: '70px', shadow: '0 4px 12px rgba(34,197,94,0.1)' }
    }
  },

  {
    id: 'tech-store',
    name: 'Tech Store',
    category: 'ecommerce',
    description: 'Modern tech product store design',
    colors: {
      primary: '#0F172A',
      secondary: '#FFFFFF',
      accent: '#3B82F6',
      text: '#1E293B',
      background: '#F8FAFC',
      border: '#E2E8F0',
      success: '#10B981',
      warning: '#F59E0B',
      error: '#EF4444'
    },
    fonts: {
      headings: { family: 'SF Pro Display, sans-serif', weight: 700, size: '40px' },
      body: { family: 'SF Pro Text, sans-serif', weight: 400, size: '16px' },
      mono: { family: 'Menlo, monospace', weight: 400, size: '13px' }
    },
    components: {
      button: { radius: '6px', padding: '12px 24px', shadow: '0 4px 12px rgba(59,130,246,0.2)' },
      card: { radius: '8px', shadow: '0 1px 3px rgba(0,0,0,0.1)' },
      navbar: { height: '68px', shadow: '0 1px 3px rgba(0,0,0,0.1)' }
    }
  },

  {
    id: 'furniture-elegant',
    name: 'Furniture Elegant',
    category: 'ecommerce',
    description: 'Elegant design for furniture and home decor',
    colors: {
      primary: '#2C2C2C',
      secondary: '#FFFFFF',
      accent: '#8B7355',
      text: '#3D3D3D',
      background: '#F7F7F7',
      border: '#DCDCDC',
      success: '#6B8E23',
      warning: '#CD853F',
      error: '#DC143C'
    },
    fonts: {
      headings: { family: 'Libre Baskerville, serif', weight: 400, size: '42px' },
      body: { family: 'Source Sans Pro, sans-serif', weight: 400, size: '16px' },
      mono: { family: 'Courier New, monospace', weight: 400, size: '14px' }
    },
    components: {
      button: { radius: '4px', padding: '14px 32px', shadow: '0 4px 12px rgba(44,44,44,0.15)' },
      card: { radius: '8px', shadow: '0 4px 12px rgba(44,44,44,0.1)' },
      navbar: { height: '72px', shadow: '0 2px 8px rgba(44,44,44,0.1)' }
    }
  },

  {
    id: 'cosmetics-beauty',
    name: 'Cosmetics Beauty',
    category: 'ecommerce',
    description: 'Beautiful design for beauty and cosmetics',
    colors: {
      primary: '#C1666B',
      secondary: '#FFFFFF',
      accent: '#E8B4B8',
      text: '#48454C',
      background: '#FEF7F7',
      border: '#F0E0E0',
      success: '#6B8E23',
      warning: '#E8B4B8',
      error: '#C1666B'
    },
    fonts: {
      headings: { family: 'Playfair Display, serif', weight: 700, size: '40px' },
      body: { family: 'Dosis, sans-serif', weight: 400, size: '16px' },
      mono: { family: 'Courier New, monospace', weight: 400, size: '14px' }
    },
    components: {
      button: { radius: '25px', padding: '12px 30px', shadow: '0 4px 12px rgba(193,102,107,0.2)' },
      card: { radius: '12px', shadow: '0 4px 12px rgba(193,102,107,0.1)' },
      navbar: { height: '70px', shadow: '0 2px 8px rgba(193,102,107,0.1)' }
    }
  },

  {
    id: 'electronics-shop',
    name: 'Electronics Shop',
    category: 'ecommerce',
    description: 'Professional electronics retailer theme',
    colors: {
      primary: '#1A365D',
      secondary: '#FFFFFF',
      accent: '#4299E1',
      text: '#2D3748',
      background: '#F7FAFC',
      border: '#CBD5E0',
      success: '#38A169',
      warning: '#ED8936',
      error: '#E53E3E'
    },
    fonts: {
      headings: { family: 'Ubuntu, sans-serif', weight: 700, size: '36px' },
      body: { family: 'Ubuntu, sans-serif', weight: 400, size: '16px' },
      mono: { family: 'Ubuntu Mono, monospace', weight: 400, size: '14px' }
    },
    components: {
      button: { radius: '6px', padding: '12px 24px', shadow: '0 4px 12px rgba(66,153,225,0.2)' },
      card: { radius: '8px', shadow: '0 2px 8px rgba(26,54,93,0.1)' },
      navbar: { height: '68px', shadow: '0 2px 8px rgba(26,54,93,0.1)' }
    }
  },

  // =================== COLORFUL THEMES (4) ===================
  {
    id: 'rainbow-bright',
    name: 'Rainbow Bright',
    category: 'colorful',
    description: 'Colorful and playful design',
    colors: {
      primary: '#FF6B6B',
      secondary: '#FFFFFF',
      accent: '#4ECDC4',
      text: '#2D3436',
      background: '#F9F9F9',
      border: '#FFE66D',
      success: '#6BCB77',
      warning: '#FFD93D',
      error: '#FF6B6B'
    },
    fonts: {
      headings: { family: 'Fredoka One, sans-serif', weight: 400, size: '40px' },
      body: { family: 'Fredoka, sans-serif', weight: 400, size: '16px' },
      mono: { family: 'Courier New, monospace', weight: 400, size: '14px' }
    },
    components: {
      button: { radius: '25px', padding: '12px 28px', shadow: '0 4px 15px rgba(255,107,107,0.3)' },
      card: { radius: '16px', shadow: '0 4px 15px rgba(78,205,196,0.2)' },
      navbar: { height: '72px', shadow: '0 4px 15px rgba(255,107,107,0.2)' }
    }
  },

  {
    id: 'ocean-blue',
    name: 'Ocean Blue',
    category: 'colorful',
    description: 'Calm ocean blue theme',
    colors: {
      primary: '#0369A1',
      secondary: '#F0F9FF',
      accent: '#06B6D4',
      text: '#0C2340',
      background: '#F0F9FF',
      border: '#BAE6FD',
      success: '#0D9488',
      warning: '#D97706',
      error: '#DC2626'
    },
    fonts: {
      headings: { family: 'Mulish, sans-serif', weight: 700, size: '38px' },
      body: { family: 'Mulish, sans-serif', weight: 400, size: '16px' },
      mono: { family: 'Roboto Mono, monospace', weight: 400, size: '14px' }
    },
    components: {
      button: { radius: '8px', padding: '12px 24px', shadow: '0 4px 12px rgba(3,105,161,0.2)' },
      card: { radius: '12px', shadow: '0 4px 12px rgba(3,105,161,0.1)' },
      navbar: { height: '70px', shadow: '0 4px 12px rgba(3,105,161,0.1)' }
    }
  },

  {
    id: 'sunset-warm',
    name: 'Sunset Warm',
    category: 'colorful',
    description: 'Warm sunset colors theme',
    colors: {
      primary: '#EA580C',
      secondary: '#FFFFFF',
      accent: '#F9A825',
      text: '#5A4A3A',
      background: '#FFF8F0',
      border: '#FFD7A6',
      success: '#26A65B',
      warning: '#F9A825',
      error: '#EA580C'
    },
    fonts: {
      headings: { family: 'Poppins, sans-serif', weight: 700, size: '40px' },
      body: { family: 'Open Sans, sans-serif', weight: 400, size: '16px' },
      mono: { family: 'Inconsolata, monospace', weight: 400, size: '14px' }
    },
    components: {
      button: { radius: '8px', padding: '12px 24px', shadow: '0 4px 12px rgba(234,88,12,0.2)' },
      card: { radius: '12px', shadow: '0 4px 12px rgba(234,88,12,0.1)' },
      navbar: { height: '70px', shadow: '0 4px 12px rgba(234,88,12,0.1)' }
    }
  },

  {
    id: 'forest-green',
    name: 'Forest Green',
    category: 'colorful',
    description: 'Natural forest green theme',
    colors: {
      primary: '#2D5016',
      secondary: '#FFFFFF',
      accent: '#7AC943',
      text: '#1B3A07',
      background: '#F0F8E8',
      border: '#D0E8B8',
      success: '#6DB646',
      warning: '#F0C649',
      error: '#E74C3C'
    },
    fonts: {
      headings: { family: 'Krub, sans-serif', weight: 700, size: '40px' },
      body: { family: 'Krub, sans-serif', weight: 400, size: '16px' },
      mono: { family: 'JetBrains Mono, monospace', weight: 400, size: '14px' }
    },
    components: {
      button: { radius: '8px', padding: '12px 24px', shadow: '0 4px 12px rgba(45,80,22,0.2)' },
      card: { radius: '12px', shadow: '0 4px 12px rgba(45,80,22,0.1)' },
      navbar: { height: '70px', shadow: '0 4px 12px rgba(45,80,22,0.1)' }
    }
  },

  // =================== MINIMAL THEMES (3) ===================
  {
    id: 'white-clean',
    name: 'White Clean',
    category: 'minimal',
    description: 'Pure white and minimal design',
    colors: {
      primary: '#FFFFFF',
      secondary: '#F5F5F5',
      accent: '#333333',
      text: '#1A1A1A',
      background: '#FFFFFF',
      border: '#DDDDDD',
      success: '#4CAF50',
      warning: '#FF9800',
      error: '#F44336'
    },
    fonts: {
      headings: { family: 'Arial, sans-serif', weight: 700, size: '32px' },
      body: { family: 'Arial, sans-serif', weight: 400, size: '16px' },
      mono: { family: 'Courier New, monospace', weight: 400, size: '14px' }
    },
    components: {
      button: { radius: '4px', padding: '10px 20px', shadow: 'none' },
      card: { radius: '4px', shadow: '0 1px 2px rgba(0,0,0,0.05)' },
      navbar: { height: '64px', shadow: '0 1px 2px rgba(0,0,0,0.05)' }
    }
  },

  {
    id: 'grey-pro',
    name: 'Grey Professional',
    category: 'minimal',
    description: 'Professional grey and white palette',
    colors: {
      primary: '#4A4A4A',
      secondary: '#FFFFFF',
      accent: '#2D5F7B',
      text: '#333333',
      background: '#F2F2F2',
      border: '#CCCCCC',
      success: '#52C41A',
      warning: '#FAAD14',
      error: '#FF4D4F'
    },
    fonts: {
      headings: { family: 'Segoe UI, sans-serif', weight: 600, size: '32px' },
      body: { family: 'Segoe UI, sans-serif', weight: 400, size: '15px' },
      mono: { family: 'Courier New, monospace', weight: 400, size: '13px' }
    },
    components: {
      button: { radius: '4px', padding: '10px 20px', shadow: '0 2px 4px rgba(0,0,0,0.1)' },
      card: { radius: '4px', shadow: '0 2px 4px rgba(0,0,0,0.1)' },
      navbar: { height: '64px', shadow: '0 2px 4px rgba(0,0,0,0.1)' }
    }
  },

  {
    id: 'beige-warm',
    name: 'Beige Warm',
    category: 'minimal',
    description: 'Warm beige and cream palette',
    colors: {
      primary: '#C19A6B',
      secondary: '#F5F1E8',
      accent: '#8B6F47',
      text: '#3E3E3E',
      background: '#FBF8F3',
      border: '#DDD5C8',
      success: '#6B8E23',
      warning: '#CD853F',
      error: '#8B3A3A'
    },
    fonts: {
      headings: { family: 'Georgia, serif', weight: 700, size: '36px' },
      body: { family: 'Georgia, serif', weight: 400, size: '16px' },
      mono: { family: 'Courier New, monospace', weight: 400, size: '14px' }
    },
    components: {
      button: { radius: '4px', padding: '12px 24px', shadow: '0 2px 6px rgba(139,111,71,0.1)' },
      card: { radius: '8px', shadow: '0 2px 6px rgba(139,111,71,0.1)' },
      navbar: { height: '68px', shadow: '0 2px 6px rgba(139,111,71,0.1)' }
    }
  },

  // =================== SPORT THEMES (2) ===================
  {
    id: 'sport-energy',
    name: 'Sport Energy',
    category: 'sport',
    description: 'High energy sports theme',
    colors: {
      primary: '#FF0000',
      secondary: '#FFFFFF',
      accent: '#FFD700',
      text: '#000000',
      background: '#F5F5F5',
      border: '#FF0000',
      success: '#00AA00',
      warning: '#FFD700',
      error: '#FF0000'
    },
    fonts: {
      headings: { family: 'Impact, sans-serif', weight: 900, size: '44px' },
      body: { family: 'Arial, sans-serif', weight: 400, size: '16px' },
      mono: { family: 'Courier New, monospace', weight: 400, size: '14px' }
    },
    components: {
      button: { radius: '4px', padding: '14px 28px', shadow: '0 4px 12px rgba(255,0,0,0.3)' },
      card: { radius: '4px', shadow: '0 4px 12px rgba(255,0,0,0.2)' },
      navbar: { height: '72px', shadow: '0 4px 12px rgba(255,0,0,0.2)' }
    }
  },

  {
    id: 'fitness-active',
    name: 'Fitness Active',
    category: 'sport',
    description: 'Active and dynamic fitness theme',
    colors: {
      primary: '#1B1B2F',
      secondary: '#FFFFFF',
      accent: '#00D4FF',
      text: '#FFFFFF',
      background: '#0F3460',
      border: '#00D4FF',
      success: '#00FF6B',
      warning: '#FFD700',
      error: '#FF4444'
    },
    fonts: {
      headings: { family: 'Exo 2, sans-serif', weight: 700, size: '40px' },
      body: { family: 'Exo 2, sans-serif', weight: 400, size: '16px' },
      mono: { family: 'JetBrains Mono, monospace', weight: 400, size: '14px' }
    },
    components: {
      button: { radius: '25px', padding: '12px 28px', shadow: '0 4px 15px rgba(0,212,255,0.3)' },
      card: { radius: '12px', shadow: '0 4px 15px rgba(0,212,255,0.2)' },
      navbar: { height: '70px', shadow: '0 4px 15px rgba(0,212,255,0.2)' }
    }
  },

  // =================== FOOD THEMES (2) ===================
  {
    id: 'food-delicious',
    name: 'Food Delicious',
    category: 'food',
    description: 'Appetizing food and restaurant theme',
    colors: {
      primary: '#E84C3D',
      secondary: '#FFFFFF',
      accent: '#F39C12',
      text: '#2C3E50',
      background: '#FFF8F0',
      border: '#F39C12',
      success: '#27AE60',
      warning: '#F39C12',
      error: '#E84C3D'
    },
    fonts: {
      headings: { family: 'Merriweather, serif', weight: 700, size: '42px' },
      body: { family: 'Merriweather, serif', weight: 400, size: '16px' },
      mono: { family: 'Courier New, monospace', weight: 400, size: '14px' }
    },
    components: {
      button: { radius: '25px', padding: '12px 28px', shadow: '0 4px 12px rgba(232,76,61,0.2)' },
      card: { radius: '12px', shadow: '0 4px 12px rgba(232,76,61,0.15)' },
      navbar: { height: '70px', shadow: '0 4px 12px rgba(232,76,61,0.15)' }
    }
  },

  {
    id: 'cafe-cozy',
    name: 'Cafe Cozy',
    category: 'food',
    description: 'Warm and cozy cafe theme',
    colors: {
      primary: '#8B4513',
      secondary: '#FFFDD0',
      accent: '#D2691E',
      text: '#3E2723',
      background: '#FFF8E7',
      border: '#D7CCC8',
      success: '#558B2F',
      warning: '#D2691E',
      error: '#8B4513'
    },
    fonts: {
      headings: { family: 'Playfair Display, serif', weight: 700, size: '40px' },
      body: { family: 'Lora, serif', weight: 400, size: '16px' },
      mono: { family: 'Courier New, monospace', weight: 400, size: '14px' }
    },
    components: {
      button: { radius: '20px', padding: '12px 26px', shadow: '0 4px 12px rgba(139,69,19,0.2)' },
      card: { radius: '10px', shadow: '0 4px 12px rgba(139,69,19,0.1)' },
      navbar: { height: '68px', shadow: '0 4px 12px rgba(139,69,19,0.1)' }
    }
  },

  // =================== BEAUTY THEMES (2) ===================
  {
    id: 'beauty-glow',
    name: 'Beauty Glow',
    category: 'beauty',
    description: 'Radiant beauty and skincare theme',
    colors: {
      primary: '#FF69B4',
      secondary: '#FFFFFF',
      accent: '#FFB6D9',
      text: '#5A4A4A',
      background: '#FFF0F6',
      border: '#FFD4E5',
      success: '#FF1493',
      warning: '#FFB6D9',
      error: '#FF69B4'
    },
    fonts: {
      headings: { family: 'Quicksand, sans-serif', weight: 700, size: '38px' },
      body: { family: 'Quicksand, sans-serif', weight: 400, size: '16px' },
      mono: { family: 'Courier New, monospace', weight: 400, size: '14px' }
    },
    components: {
      button: { radius: '25px', padding: '12px 28px', shadow: '0 4px 12px rgba(255,105,180,0.2)' },
      card: { radius: '12px', shadow: '0 4px 12px rgba(255,105,180,0.1)' },
      navbar: { height: '70px', shadow: '0 4px 12px rgba(255,105,180,0.1)' }
    }
  },

  {
    id: 'cosmetics-pink',
    name: 'Cosmetics Pink',
    category: 'beauty',
    description: 'Elegant pink cosmetics theme',
    colors: {
      primary: '#D946A6',
      secondary: '#FFFFFF',
      accent: '#EC4899',
      text: '#3F3F46',
      background: '#FDF2F8',
      border: '#FBCFE8',
      success: '#EC4899',
      warning: '#F59E0B',
      error: '#EF4444'
    },
    fonts: {
      headings: { family: 'Nunito, sans-serif', weight: 700, size: '40px' },
      body: { family: 'Nunito, sans-serif', weight: 400, size: '16px' },
      mono: { family: 'Fira Code, monospace', weight: 400, size: '14px' }
    },
    components: {
      button: { radius: '20px', padding: '12px 28px', shadow: '0 4px 12px rgba(217,70,166,0.2)' },
      card: { radius: '12px', shadow: '0 4px 12px rgba(217,70,166,0.1)' },
      navbar: { height: '70px', shadow: '0 4px 12px rgba(217,70,166,0.1)' }
    }
  },

  // =================== TRAVEL THEMES (2) ===================
  {
    id: 'travel-adventure',
    name: 'Travel Adventure',
    category: 'travel',
    description: 'Adventure and travel exploration theme',
    colors: {
      primary: '#1A472A',
      secondary: '#FFFFFF',
      accent: '#FF6B35',
      text: '#1A1A1A',
      background: '#F5F5F0',
      border: '#D4A373',
      success: '#2ECC71',
      warning: '#FF6B35',
      error: '#E74C3C'
    },
    fonts: {
      headings: { family: 'Montserrat, sans-serif', weight: 700, size: '42px' },
      body: { family: 'Open Sans, sans-serif', weight: 400, size: '16px' },
      mono: { family: 'Inconsolata, monospace', weight: 400, size: '14px' }
    },
    components: {
      button: { radius: '4px', padding: '12px 24px', shadow: '0 4px 12px rgba(26,71,42,0.2)' },
      card: { radius: '8px', shadow: '0 4px 12px rgba(26,71,42,0.1)' },
      navbar: { height: '70px', shadow: '0 4px 12px rgba(26,71,42,0.1)' }
    }
  },

  {
    id: 'wanderlust',
    name: 'Wanderlust',
    category: 'travel',
    description: 'Inspiring travel and wanderlust theme',
    colors: {
      primary: '#2E86AB',
      secondary: '#FFFFFF',
      accent: '#A23B72',
      text: '#1B263B',
      background: '#F8F9FA',
      border: '#D4B5D4',
      success: '#10B981',
      warning: '#F59E0B',
      error: '#EF4444'
    },
    fonts: {
      headings: { family: 'Cormorant Garamond, serif', weight: 700, size: '44px' },
      body: { family: 'Lato, sans-serif', weight: 400, size: '16px' },
      mono: { family: 'JetBrains Mono, monospace', weight: 400, size: '14px' }
    },
    components: {
      button: { radius: '8px', padding: '12px 24px', shadow: '0 4px 12px rgba(46,134,171,0.2)' },
      card: { radius: '12px', shadow: '0 4px 12px rgba(46,134,171,0.1)' },
      navbar: { height: '70px', shadow: '0 4px 12px rgba(46,134,171,0.1)' }
    }
  },

  // =================== REAL ESTATE THEMES (2) ===================
  {
    id: 'property-pro',
    name: 'Property Pro',
    category: 'realestate',
    description: 'Professional real estate property theme',
    colors: {
      primary: '#003D82',
      secondary: '#FFFFFF',
      accent: '#0066CC',
      text: '#1A1A1A',
      background: '#F5F5F5',
      border: '#D4D4D4',
      success: '#22C55E',
      warning: '#F59E0B',
      error: '#EF4444'
    },
    fonts: {
      headings: { family: 'Roboto, sans-serif', weight: 700, size: '40px' },
      body: { family: 'Roboto, sans-serif', weight: 400, size: '16px' },
      mono: { family: 'Roboto Mono, monospace', weight: 400, size: '14px' }
    },
    components: {
      button: { radius: '4px', padding: '12px 24px', shadow: '0 2px 8px rgba(0,61,130,0.2)' },
      card: { radius: '4px', shadow: '0 2px 8px rgba(0,61,130,0.1)' },
      navbar: { height: '68px', shadow: '0 2px 8px rgba(0,61,130,0.1)' }
    }
  },

  {
    id: 'home-sweet',
    name: 'Home Sweet',
    category: 'realestate',
    description: 'Warm and welcoming home theme',
    colors: {
      primary: '#D2501E',
      secondary: '#FFFFFF',
      accent: '#E8A76B',
      text: '#3E3E3E',
      background: '#FFF5EB',
      border: '#E8D4C4',
      success: '#6B8E23',
      warning: '#E8A76B',
      error: '#D2501E'
    },
    fonts: {
      headings: { family: 'Playfair Display, serif', weight: 700, size: '42px' },
      body: { family: 'Raleway, sans-serif', weight: 400, size: '16px' },
      mono: { family: 'Courier New, monospace', weight: 400, size: '14px' }
    },
    components: {
      button: { radius: '20px', padding: '12px 28px', shadow: '0 4px 12px rgba(210,80,30,0.2)' },
      card: { radius: '12px', shadow: '0 4px 12px rgba(210,80,30,0.1)' },
      navbar: { height: '70px', shadow: '0 4px 12px rgba(210,80,30,0.1)' }
    }
  },

  // =================== EDUCATION THEMES (2) ===================
  {
    id: 'education-learn',
    name: 'Education Learn',
    category: 'education',
    description: 'Educational and learning platform theme',
    colors: {
      primary: '#1E3A8A',
      secondary: '#FFFFFF',
      accent: '#3B82F6',
      text: '#1F2937',
      background: '#F3F4F6',
      border: '#E5E7EB',
      success: '#10B981',
      warning: '#F59E0B',
      error: '#EF4444'
    },
    fonts: {
      headings: { family: 'Inter, sans-serif', weight: 700, size: '38px' },
      body: { family: 'Inter, sans-serif', weight: 400, size: '16px' },
      mono: { family: 'Fira Code, monospace', weight: 400, size: '14px' }
    },
    components: {
      button: { radius: '6px', padding: '12px 24px', shadow: '0 4px 12px rgba(30,58,138,0.2)' },
      card: { radius: '8px', shadow: '0 4px 12px rgba(30,58,138,0.1)' },
      navbar: { height: '68px', shadow: '0 4px 12px rgba(30,58,138,0.1)' }
    }
  },

  {
    id: 'course-builder',
    name: 'Course Builder',
    category: 'education',
    description: 'Online course and training platform',
    colors: {
      primary: '#6F3FF2',
      secondary: '#FFFFFF',
      accent: '#A78BFA',
      text: '#1F2937',
      background: '#F9F5FF',
      border: '#E9D5FF',
      success: '#10B981',
      warning: '#F59E0B',
      error: '#EF4444'
    },
    fonts: {
      headings: { family: 'Poppins, sans-serif', weight: 700, size: '40px' },
      body: { family: 'Poppins, sans-serif', weight: 400, size: '16px' },
      mono: { family: 'JetBrains Mono, monospace', weight: 400, size: '14px' }
    },
    components: {
      button: { radius: '8px', padding: '12px 24px', shadow: '0 4px 12px rgba(111,63,242,0.2)' },
      card: { radius: '12px', shadow: '0 4px 12px rgba(111,63,242,0.1)' },
      navbar: { height: '70px', shadow: '0 4px 12px rgba(111,63,242,0.1)' }
    }
  }
];