import { Injectable } from '@nestjs/common';
import { PrismaService } from '../../database/prisma.service';

@Injectable()
export class PremiumThemesService {
  constructor(private prisma: PrismaService) {}

  // প্রিমিয়াম থিম লিস্ট
  getPremiumThemes() {
    return {
      themes: [
        // Modern Themes
        {
          id: 'modern-minimal',
          name: 'Modern Minimal',
          description: 'Clean and minimalist design',
          colors: { primary: '#000', secondary: '#fff', accent: '#0066ff' },
          category: 'modern'
        },
        {
          id: 'elegant-dark',
          name: 'Elegant Dark',
          description: 'Luxury dark theme',
          colors: { primary: '#1a1a1a', secondary: '#fff', accent: '#ffd700' },
          category: 'luxury'
        },
        {
          id: 'vibrant-neon',
          name: 'Vibrant Neon',
          description: 'Bold and colorful design',
          colors: { primary: '#ff0080', secondary: '#fff', accent: '#00ffff' },
          category: 'modern'
        },

        // E-Commerce Themes
        {
          id: 'fashion-pro',
          name: 'Fashion Pro',
          description: 'Perfect for fashion & apparel stores',
          colors: { primary: '#222', secondary: '#fff', accent: '#e91e63' },
          category: 'ecommerce'
        },
        {
          id: 'grocery-fresh',
          name: 'Grocery Fresh',
          description: 'Fresh and vibrant for grocery stores',
          colors: { primary: '#22c55e', secondary: '#fff', accent: '#f59e0b' },
          category: 'ecommerce'
        },
        {
          id: 'tech-store',
          name: 'Tech Store',
          description: 'Modern tech product store design',
          colors: { primary: '#0f172a', secondary: '#fff', accent: '#3b82f6' },
          category: 'ecommerce'
        },

        // Luxury Themes
        {
          id: 'luxury-gold',
          name: 'Luxury Gold',
          description: 'Premium gold & black design',
          colors: { primary: '#1a1a1a', secondary: '#fff', accent: '#d4af37' },
          category: 'luxury'
        },
        {
          id: 'premium-black',
          name: 'Premium Black',
          description: 'High-end black theme',
          colors: { primary: '#0a0a0a', secondary: '#fff', accent: '#c0a080' },
          category: 'luxury'
        },

        // Colorful Themes
        {
          id: 'rainbow-bright',
          name: 'Rainbow Bright',
          description: 'Colorful and playful theme',
          colors: { primary: '#ff6b6b', secondary: '#fff', accent: '#4ecdc4' },
          category: 'colorful'
        },
        {
          id: 'ocean-blue',
          name: 'Ocean Blue',
          description: 'Calm ocean blue theme',
          colors: { primary: '#0369a1', secondary: '#f0f9ff', accent: '#06b6d4' },
          category: 'colorful'
        },

        // Additional 20+ Themes
        // Minimal Themes
        { id: 'white-clean', name: 'White Clean', category: 'minimal' },
        { id: 'grey-pro', name: 'Grey Professional', category: 'minimal' },
        { id: 'beige-warm', name: 'Beige Warm', category: 'minimal' },

        // Sport Themes
        { id: 'sport-energy', name: 'Sport Energy', category: 'sport' },
        { id: 'fitness-active', name: 'Fitness Active', category: 'sport' },

        // Food Themes
        { id: 'food-delicious', name: 'Food Delicious', category: 'food' },
        { id: 'cafe-cozy', name: 'Cafe Cozy', category: 'food' },

        // Beauty Themes
        { id: 'beauty-glow', name: 'Beauty Glow', category: 'beauty' },
        { id: 'cosmetics-pink', name: 'Cosmetics Pink', category: 'beauty' },

        // Travel Themes
        { id: 'travel-adventure', name: 'Travel Adventure', category: 'travel' },
        { id: 'wanderlust', name: 'Wanderlust', category: 'travel' },

        // Real Estate Themes
        { id: 'property-pro', name: 'Property Pro', category: 'realestate' },
        { id: 'home-sweet', name: 'Home Sweet', category: 'realestate' },

        // Education Themes
        { id: 'education-learn', name: 'Education Learn', category: 'education' },
        { id: 'course-builder', name: 'Course Builder', category: 'education' },

        // More Modern Themes
        { id: 'glassmorphism', name: 'Glassmorphism', category: 'modern' },
        { id: 'neumorphism', name: 'Neumorphism', category: 'modern' },
        { id: 'brutalism', name: 'Brutalism', category: 'modern' }
      ]
    };
  }

  // থিম প্রয়োগ করুন
  async applyTheme(tenantId: string, themeId: string) {
    const themes = this.getPremiumThemes();
    const selectedTheme = themes.themes.find((t) => t.id === themeId);

    if (!selectedTheme) throw new Error('Theme not found');

    const config = await this.prisma.themeConfiguration.upsert({
      where: { tenantId },
      create: {
        tenantId,
        themeName: selectedTheme.name,
        themeId,
        colors: selectedTheme.colors || {}
      },
      update: {
        themeName: selectedTheme.name,
        themeId
      }
    });

    return { success: true, data: config };
  }

  // কাস্টম থিম সেভ করুন
  async saveCustomTheme(tenantId: string, colors: any, customCSS?: string) {
    const config = await this.prisma.themeConfiguration.upsert({
      where: { tenantId },
      create: {
        tenantId,
        themeName: 'Custom Theme',
        themeId: 'custom',
        colors,
        customCSS
      },
      update: {
        colors,
        customCSS
      }
    });

    return { success: true, data: config };
  }
}